/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor.ajax;

import com.github.dandelion.datatables.core.feature.AbstractFeature;
import com.github.dandelion.datatables.core.feature.AjaxFeature;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesAttrProcessor;
import com.github.dandelion.datatables.thymeleaf.util.Utils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class TableUrlAttrProcessor
extends AbstractDatatablesAttrProcessor {
    public TableUrlAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 8000;
    }

    @Override
    protected ProcessorResult doProcessAttribute(Arguments arguments, Element element, String attributeName, HtmlTable table) {
        HttpServletRequest request = ((IWebContext)arguments.getContext()).getHttpServletRequest();
        String attrValue = element.getAttributeValue(attributeName).toLowerCase().trim();
        if (table != null && StringUtils.isNotBlank((String)attrValue)) {
            if (attrValue.startsWith("/")) {
                table.setDatasourceUrl(Utils.getBaseUrl(request) + attrValue);
            } else {
                table.setDatasourceUrl(attrValue);
            }
            if (table.getServerSide() == null || !table.getServerSide().booleanValue()) {
                table.registerFeature((AbstractFeature)new AjaxFeature());
            }
        }
        return ProcessorResult.ok();
    }
}

