/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor.basic;

import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesAttrProcessor;
import org.apache.commons.lang.StringUtils;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class TableAppearAttrProcessor
extends AbstractDatatablesAttrProcessor {
    public TableAppearAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 8000;
    }

    @Override
    protected ProcessorResult doProcessAttribute(Arguments arguments, Element element, String attributeName, HtmlTable table) {
        String attrValue = element.getAttributeValue(attributeName).toLowerCase().trim();
        if (table != null && StringUtils.isNotBlank((String)attrValue)) {
            if (attrValue.contains(",") || "fadein".equals(attrValue.toLowerCase().trim())) {
                String[] tmp = attrValue.toLowerCase().trim().split(",");
                table.setAppear("fadein");
                if (tmp.length > 1) {
                    table.setAppearDuration(tmp[1]);
                }
            } else {
                table.setAppear("block");
            }
        }
        return ProcessorResult.ok();
    }
}

