/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor.basic;

import com.github.dandelion.datatables.core.exception.DataTableProcessingException;
import com.github.dandelion.datatables.core.export.ExportLinkPosition;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesAttrProcessor;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class TableExportLinksAttrProcessor
extends AbstractDatatablesAttrProcessor {
    private static Logger logger = LoggerFactory.getLogger(TableExportLinksAttrProcessor.class);

    public TableExportLinksAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 8000;
    }

    @Override
    protected ProcessorResult doProcessAttribute(Arguments arguments, Element element, String attributeName, HtmlTable table) {
        String attrValue = element.getAttributeValue(attributeName).toLowerCase().trim();
        ArrayList<ExportLinkPosition> positionList = new ArrayList<ExportLinkPosition>();
        if (StringUtils.isNotBlank((String)attrValue)) {
            String[] positions;
            for (String position : positions = attrValue.trim().split(",")) {
                try {
                    positionList.add(ExportLinkPosition.valueOf((String)position.toUpperCase().trim()));
                }
                catch (IllegalArgumentException e) {
                    logger.error("The export cannot be activated for the table {}. ", (Object)table.getId());
                    logger.error("{} is not a valid value among {}", (Object)position, (Object)ExportLinkPosition.values());
                    throw new DataTableProcessingException((Throwable)e);
                }
            }
        } else {
            positionList.add(ExportLinkPosition.TOP_RIGHT);
        }
        table.setExportLinkPositions(positionList);
        return ProcessorResult.ok();
    }
}

