/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor.basic;

import com.github.dandelion.datatables.core.exception.DataTableProcessingException;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesAttrProcessor;
import org.apache.commons.lang.StringUtils;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class TableLengthMenuAttrProcessor
extends AbstractDatatablesAttrProcessor {
    public TableLengthMenuAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 8000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected ProcessorResult doProcessAttribute(Arguments arguments, Element element, String attributeName, HtmlTable table) {
        String attrValue = element.getAttributeValue(attributeName);
        if (!StringUtils.isNotBlank((String)attrValue)) return ProcessorResult.ok();
        String[] tmp = attrValue.split(";");
        if (tmp.length > 1) {
            String[] tmp3;
            String[] tmp2 = tmp[0].split(",");
            if (tmp2.length != (tmp3 = tmp[1].split(",")).length) throw new DataTableProcessingException("You must provide the exact same number of elements separated by a \";\"");
            table.setLengthMenu("[[" + tmp[0] + "],[" + tmp[1] + "]]");
            return ProcessorResult.ok();
        } else {
            table.setLengthMenu("[" + attrValue + "]");
        }
        return ProcessorResult.ok();
    }
}

