/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor.basic;

import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesAttrProcessor;
import org.apache.commons.lang.StringUtils;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class TableStripeClassesAttrProcessor
extends AbstractDatatablesAttrProcessor {
    public TableStripeClassesAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 8000;
    }

    @Override
    protected ProcessorResult doProcessAttribute(Arguments arguments, Element element, String attributeName, HtmlTable table) {
        String attrValue = element.getAttributeValue(attributeName).toLowerCase().trim();
        if (StringUtils.isNotBlank((String)attrValue)) {
            String[] tmp = attrValue.split(";");
            String stripeTmp = "[";
            for (String cssClass : tmp) {
                stripeTmp = stripeTmp + "'" + cssClass + "',";
            }
            stripeTmp = stripeTmp + "]";
            table.setStripeClasses(stripeTmp);
        }
        return ProcessorResult.ok();
    }
}

