/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor.basic;

import com.github.dandelion.datatables.core.feature.FilterType;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesAttrProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class ThFilterTypeAttrProcessor
extends AbstractDatatablesAttrProcessor {
    private static Logger logger = LoggerFactory.getLogger(ThFilterTypeAttrProcessor.class);

    public ThFilterTypeAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 8000;
    }

    @Override
    protected ProcessorResult doProcessAttribute(Arguments arguments, Element element, String attributeName, HtmlTable table) {
        logger.debug("{} attribute found", (Object)attributeName);
        if (table != null) {
            FilterType filterType = null;
            String attrValue = element.getAttributeValue(attributeName.trim().toUpperCase());
            if (attrValue != null) {
                try {
                    filterType = FilterType.valueOf((String)attrValue.toUpperCase().trim());
                }
                catch (IllegalArgumentException e) {
                    logger.error("{} is not a valid value among {}. Please choose a valid one.", (Object)filterType, (Object)FilterType.values());
                    throw new IllegalArgumentException("Wrong value for FilterType");
                }
                logger.debug("Extracted value : {}", (Object)filterType);
            }
            if (filterType != null) {
                table.getLastHeaderRow().getLastColumn().setFilterType(filterType);
            }
        }
        return ProcessorResult.ok();
    }
}

