/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor.feature;

import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.export.ExportType;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.util.RequestHelper;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesAttrProcessor;
import javax.servlet.http.HttpServletRequest;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class TbodyExportAutoSizeAttrProcessor
extends AbstractDatatablesAttrProcessor {
    public TbodyExportAutoSizeAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 8000;
    }

    @Override
    protected ProcessorResult doProcessAttribute(Arguments arguments, Element element, String attributeName, HtmlTable table) {
        HttpServletRequest request = ((IWebContext)arguments.getContext()).getHttpServletRequest();
        Boolean attrValue = Boolean.parseBoolean(element.getAttributeValue(attributeName));
        ExportType exportType = ExportType.valueOf((String)attributeName.split(":")[1].toUpperCase().trim());
        if (table.getExportConfMap().containsKey(exportType)) {
            ((ExportConf)table.getExportConfMap().get(exportType)).setAutoSize(attrValue);
        } else {
            String url = RequestHelper.getCurrentUrlWithParameters((HttpServletRequest)request);
            url = url.contains("?") ? url + "&" : url + "?";
            url = url + "dtt=" + exportType.getUrlParameter() + "&" + "dti" + "=" + table.getId();
            ExportConf conf = new ExportConf(exportType, url);
            conf.setAutoSize(attrValue);
            table.getExportConfMap().put(exportType, conf);
        }
        return ProcessorResult.ok();
    }
}

