/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor.theme;

import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.theme.AbstractTheme;
import com.github.dandelion.datatables.core.theme.Bootstrap2Theme;
import com.github.dandelion.datatables.core.theme.JQueryUITheme;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesAttrProcessor;
import com.github.dandelion.datatables.thymeleaf.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class TableThemeAttrProcessor
extends AbstractDatatablesAttrProcessor {
    private static Logger logger = LoggerFactory.getLogger(TableThemeAttrProcessor.class);

    public TableThemeAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 8000;
    }

    @Override
    protected ProcessorResult doProcessAttribute(Arguments arguments, Element element, String attributeName, HtmlTable table) {
        HtmlTable htmlTable = Utils.getTable(arguments);
        String attrValue = element.getAttributeValue(attributeName);
        if (htmlTable != null) {
            if (attrValue.trim().toLowerCase().equals("bootstrap2")) {
                htmlTable.setTheme((AbstractTheme)new Bootstrap2Theme());
            } else if (attrValue.trim().toLowerCase().equals("jqueryui")) {
                htmlTable.setTheme((AbstractTheme)new JQueryUITheme());
            } else {
                logger.warn("Theme {} is not recognized. Only 'bootstrap2 and jQueryUI' exists for now.", (Object)attrValue);
            }
        }
        return ProcessorResult.ok();
    }
}

