/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.dialect;

import com.github.dandelion.datatables.core.exception.DataTableProcessingException;
import com.github.dandelion.datatables.thymeleaf.matcher.ElementNameWithoutPrefixProcessorMatcher;
import com.github.dandelion.datatables.thymeleaf.processor.ColumnInitializerElProcessor;
import com.github.dandelion.datatables.thymeleaf.processor.TableFinalizerElProcessor;
import com.github.dandelion.datatables.thymeleaf.processor.TableInitializerElProcessor;
import com.github.dandelion.datatables.thymeleaf.processor.TbodyElProcessor;
import com.github.dandelion.datatables.thymeleaf.processor.TdElProcessor;
import com.github.dandelion.datatables.thymeleaf.processor.TrElProcessor;
import java.lang.reflect.InvocationTargetException;
import org.thymeleaf.processor.IElementNameProcessorMatcher;
import org.thymeleaf.processor.element.AbstractElementProcessor;

public enum DatatablesElProcessors {
    TABLE_INITIALIZER(TableInitializerElProcessor.class, "table", "dt:table", "true"),
    TABLE_FINALIZER(TableFinalizerElProcessor.class, "div", "dt:tmp", "internalUse"),
    COLUMN_INITIALIZER(ColumnInitializerElProcessor.class, "th"),
    TBODY(TbodyElProcessor.class, "tbody"),
    TR(TrElProcessor.class, "tr", "dt:data", "internalUse"),
    TD(TdElProcessor.class, "td", "dt:data", "internalUse");

    private Class<? extends AbstractElementProcessor> processorClass;
    private String elementName;
    private String filterAttributeName;
    private String filterAttributeValue;
    private boolean withFilter;

    private DatatablesElProcessors(Class<? extends AbstractElementProcessor> processorClass, String elementName) {
        this.processorClass = processorClass;
        this.elementName = elementName;
        this.withFilter = false;
    }

    private DatatablesElProcessors(Class<? extends AbstractElementProcessor> processorClass, String elementName, String filterAttributeName, String filterAttributeValue) {
        this.processorClass = processorClass;
        this.elementName = elementName;
        this.filterAttributeName = filterAttributeName;
        this.filterAttributeValue = filterAttributeValue;
        this.withFilter = true;
    }

    public AbstractElementProcessor getProcessor() {
        ElementNameWithoutPrefixProcessorMatcher matcher = this.withFilter ? new ElementNameWithoutPrefixProcessorMatcher(this.elementName, this.filterAttributeName, this.filterAttributeValue) : new ElementNameWithoutPrefixProcessorMatcher(this.elementName);
        try {
            return this.processorClass.getDeclaredConstructor(IElementNameProcessorMatcher.class).newInstance(matcher);
        }
        catch (InstantiationException e) {
            throw new DataTableProcessingException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DataTableProcessingException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new DataTableProcessingException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new DataTableProcessingException((Throwable)e);
        }
    }
}

