/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.matcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.IElementNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorMatchingContext;
import org.thymeleaf.util.Validate;

public class ElementNameWithoutPrefixProcessorMatcher
implements IElementNameProcessorMatcher {
    private final String elementName;
    private final Map<String, String> attributeValuesByNameFilter;

    public ElementNameWithoutPrefixProcessorMatcher(String elementName) {
        this(elementName, null);
    }

    public ElementNameWithoutPrefixProcessorMatcher(String elementName, String filterAttributeName, String filterAttributeValue) {
        this(elementName, Collections.singletonMap(filterAttributeName, filterAttributeValue));
    }

    public ElementNameWithoutPrefixProcessorMatcher(String elementName, Map<String, String> attributeValuesByNameFilter) {
        Validate.notEmpty((String)elementName, (String)"Element name cannot be null or empty");
        this.elementName = elementName;
        if (attributeValuesByNameFilter == null || attributeValuesByNameFilter.size() == 0) {
            this.attributeValuesByNameFilter = null;
        } else {
            HashMap<String, String> newAttributeValuesByNameFilter = new HashMap<String, String>(attributeValuesByNameFilter.size() + 1, 1.0f);
            newAttributeValuesByNameFilter.putAll(attributeValuesByNameFilter);
            this.attributeValuesByNameFilter = Collections.unmodifiableMap(newAttributeValuesByNameFilter);
        }
    }

    public boolean matches(Node node, ProcessorMatchingContext context) {
        if (!(node instanceof Element)) {
            return false;
        }
        Element element = (Element)node;
        String completeNormalizedElementName = Node.normalizeName((String)this.getElementName(context));
        if (!element.getNormalizedName().equals(completeNormalizedElementName)) {
            return false;
        }
        if (this.attributeValuesByNameFilter != null) {
            for (Map.Entry<String, String> filterAttributeEntry : this.attributeValuesByNameFilter.entrySet()) {
                String elementAttributeValue;
                String filterAttributeName = filterAttributeEntry.getKey();
                String filterAttributeValue = filterAttributeEntry.getValue();
                if (!(!element.hasAttribute(filterAttributeName) ? filterAttributeValue != null : ((elementAttributeValue = element.getAttributeValue(filterAttributeName)) == null ? filterAttributeValue != null : !elementAttributeValue.equals(filterAttributeValue)))) continue;
                return false;
            }
        }
        return true;
    }

    public Class<? extends Element> appliesTo() {
        return Element.class;
    }

    public String getElementName(ProcessorMatchingContext context) {
        return this.elementName;
    }
}

