/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor;

import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesElProcessor;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Text;
import org.thymeleaf.processor.IElementNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class ColumnInitializerElProcessor
extends AbstractDatatablesElProcessor {
    private static Logger logger = LoggerFactory.getLogger(ColumnInitializerElProcessor.class);

    public ColumnInitializerElProcessor(IElementNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 8000;
    }

    @Override
    protected ProcessorResult doProcessElement(Arguments arguments, Element element, HtmlTable table) {
        logger.debug("{} element found", (Object)element.getNormalizedName());
        String content = null;
        content = element.getFirstChild() instanceof Text ? ((Text)element.getFirstChild()).getContent().trim() : element.getChildren().toString();
        HtmlColumn htmlColumn = new HtmlColumn(Boolean.valueOf(true), content);
        if (element.hasAttribute("dt:property")) {
            htmlColumn.setProperty(element.getAttributeValue("dt:property").trim());
            element.removeAttribute("dt:property");
        }
        if (element.hasAttribute("dt:renderFunction")) {
            htmlColumn.setRenderFunction(element.getAttributeValue("dt:renderFunction").trim());
            element.removeAttribute("dt:renderFunction");
        }
        if (element.hasAttribute("dt:default")) {
            htmlColumn.setDefaultValue(element.getAttributeValue("dt:default").trim());
            element.removeAttribute("dt:default");
        } else {
            htmlColumn.setDefaultValue("");
        }
        if (table != null) {
            table.getLastHeaderRow().addHeaderColumn(htmlColumn);
        }
        HashMap<String, HtmlColumn> newVariable = new HashMap<String, HtmlColumn>();
        newVariable.put("htmlColumn", htmlColumn);
        return ProcessorResult.setLocalVariables(newVariable);
    }
}

