/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor;

import com.github.dandelion.datatables.core.asset.DisplayType;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesElProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Text;
import org.thymeleaf.processor.IElementNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;

public class TdElProcessor
extends AbstractDatatablesElProcessor {
    private static Logger logger = LoggerFactory.getLogger(TdElProcessor.class);

    public TdElProcessor(IElementNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 4002;
    }

    @Override
    protected ProcessorResult doProcessElement(Arguments arguments, Element element, HtmlTable table) {
        if (table != null) {
            HtmlColumn column = null;
            String content = null;
            String attrValue = null;
            if (element.hasAttribute("dt:csv") || element.hasAttribute("dt:xml") || element.hasAttribute("dt:pdf") || element.hasAttribute("dt:xls") || element.hasAttribute("dt:xlsx")) {
                if (element.hasAttribute("dt:csv")) {
                    attrValue = element.getAttributeValue("dt:csv");
                    content = StandardExpressionProcessor.processExpression((Arguments)arguments, (String)attrValue).toString();
                    element.removeAttribute("dt:csv");
                    column = new HtmlColumn(DisplayType.CSV);
                    column.setContent(content);
                    table.getLastBodyRow().addColumn(column);
                }
                if (element.hasAttribute("dt:xml")) {
                    attrValue = element.getAttributeValue("dt:xml");
                    content = StandardExpressionProcessor.processExpression((Arguments)arguments, (String)attrValue).toString();
                    element.removeAttribute("dt:xml");
                    column = new HtmlColumn(DisplayType.XML);
                    column.setContent(content);
                    table.getLastBodyRow().addColumn(column);
                }
                if (element.hasAttribute("dt:pdf")) {
                    attrValue = element.getAttributeValue("dt:pdf");
                    content = StandardExpressionProcessor.processExpression((Arguments)arguments, (String)attrValue).toString();
                    element.removeAttribute("dt:pdf");
                    column = new HtmlColumn(DisplayType.PDF);
                    column.setContent(content);
                    table.getLastBodyRow().addColumn(column);
                }
                if (element.hasAttribute("dt:xls")) {
                    attrValue = element.getAttributeValue("dt:xls");
                    content = StandardExpressionProcessor.processExpression((Arguments)arguments, (String)attrValue).toString();
                    element.removeAttribute("dt:xls");
                    column = new HtmlColumn(DisplayType.XLS);
                    column.setContent(content);
                    table.getLastBodyRow().addColumn(column);
                }
                if (element.hasAttribute("dt:xlsx")) {
                    attrValue = element.getAttributeValue("dt:xlsx");
                    content = StandardExpressionProcessor.processExpression((Arguments)arguments, (String)attrValue).toString();
                    element.removeAttribute("dt:xlsx");
                    column = new HtmlColumn(DisplayType.XLSX);
                    column.setContent(content);
                    table.getLastBodyRow().addColumn(column);
                }
            } else if (element.getFirstChild() instanceof Text) {
                table.getLastBodyRow().addColumn(((Text)element.getFirstChild()).getContent().trim());
            } else {
                logger.warn("Only cells containing plain text are supported, those containing HTML code are still not !");
                table.getLastBodyRow().addColumn("");
            }
        }
        if (element.hasAttribute("dt:data")) {
            element.removeAttribute("dt:data");
        }
        return ProcessorResult.OK;
    }
}

