/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor.basic;

import com.github.dandelion.datatables.core.exception.DataTableProcessingException;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.export.ExportType;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.util.RequestHelper;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesAttrProcessor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class TableExportAttrProcessor
extends AbstractDatatablesAttrProcessor {
    private static Logger logger = LoggerFactory.getLogger(TableExportAttrProcessor.class);

    public TableExportAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 8000;
    }

    @Override
    protected ProcessorResult doProcessAttribute(Arguments arguments, Element element, String attributeName, HtmlTable table) {
        logger.debug("{} attribute found", (Object)attributeName);
        HttpServletRequest request = ((IWebContext)arguments.getContext()).getHttpServletRequest();
        String attrValue = element.getAttributeValue(attributeName);
        logger.debug("Extracted value : {}", (Object)attrValue);
        if (StringUtils.isNotBlank((String)attrValue) && table != null) {
            String[] exportTypes;
            table.setIsExportable(Boolean.valueOf(true));
            for (String exportTypeString : exportTypes = attrValue.trim().toUpperCase().split(",")) {
                ExportType type = null;
                try {
                    type = ExportType.valueOf((String)exportTypeString.trim().toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    logger.error("The export cannot be activated for the table {}. ", (Object)table.getId());
                    logger.error("{} is not a valid value among {}", (Object)exportTypeString, (Object)ExportType.values());
                    throw new DataTableProcessingException((Throwable)e);
                }
                if (table.getExportConfMap().containsKey(type)) continue;
                String url = RequestHelper.getCurrentUrlWithParameters((HttpServletRequest)request);
                url = url.contains("?") ? url + "&" : url + "?";
                url = url + "dtt=" + type.getUrlParameter() + "&" + "dti" + "=" + table.getId();
                ExportConf conf = new ExportConf(type, url);
                table.getExportConfMap().put(type, conf);
            }
        }
        return ProcessorResult.ok();
    }
}

