/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor.basic;

import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesAttrProcessor;
import com.github.dandelion.datatables.thymeleaf.util.Utils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class TableLabelsAttrProcessor
extends AbstractDatatablesAttrProcessor {
    public TableLabelsAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 8000;
    }

    @Override
    protected ProcessorResult doProcessAttribute(Arguments arguments, Element element, String attributeName, HtmlTable table) {
        HttpServletRequest request = ((IWebContext)arguments.getContext()).getHttpServletRequest();
        HtmlTable htmlTable = Utils.getTable(arguments);
        String attrValue = element.getAttributeValue(attributeName);
        if (htmlTable != null && StringUtils.isNotBlank((String)attrValue)) {
            htmlTable.setLabels(Utils.getBaseUrl(request) + attrValue);
        }
        return ProcessorResult.ok();
    }
}

