/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor.basic;

import com.github.dandelion.datatables.core.feature.AbstractFeature;
import com.github.dandelion.datatables.core.feature.PaginationType;
import com.github.dandelion.datatables.core.feature.PaginationTypeBootstrapFeature;
import com.github.dandelion.datatables.core.feature.PaginationTypeFourButtonFeature;
import com.github.dandelion.datatables.core.feature.PaginationTypeInputFeature;
import com.github.dandelion.datatables.core.feature.PaginationTypeListboxFeature;
import com.github.dandelion.datatables.core.feature.PaginationTypeScrollingFeature;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesAttrProcessor;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class TablePaginationTypeAttrProcessor
extends AbstractDatatablesAttrProcessor {
    private static Logger logger = LoggerFactory.getLogger(TablePaginationTypeAttrProcessor.class);

    public TablePaginationTypeAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 8000;
    }

    @Override
    protected ProcessorResult doProcessAttribute(Arguments arguments, Element element, String attributeName, HtmlTable table) {
        String attrValue = element.getAttributeValue(attributeName).toLowerCase().trim();
        if (StringUtils.isNotBlank((String)attrValue)) {
            PaginationType paginationType = null;
            try {
                paginationType = PaginationType.valueOf((String)attrValue);
            }
            catch (IllegalArgumentException e) {
                logger.error("{} is not a valid value among {}", (Object)attrValue, (Object)PaginationType.values());
                throw new IllegalArgumentException("Wrong value for PaginationType");
            }
            switch (paginationType) {
                case bootstrap: {
                    table.registerFeature((AbstractFeature)new PaginationTypeBootstrapFeature());
                    break;
                }
                case input: {
                    table.registerFeature((AbstractFeature)new PaginationTypeInputFeature());
                    break;
                }
                case listbox: {
                    table.registerFeature((AbstractFeature)new PaginationTypeListboxFeature());
                    break;
                }
                case scrolling: {
                    table.registerFeature((AbstractFeature)new PaginationTypeScrollingFeature());
                    break;
                }
                case four_button: {
                    table.registerFeature((AbstractFeature)new PaginationTypeFourButtonFeature());
                    break;
                }
            }
        }
        return ProcessorResult.ok();
    }
}

