/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor.theme;

import com.github.dandelion.datatables.core.exception.DataTableProcessingException;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.theme.ThemeOption;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesAttrProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class TableThemeOptionAttrProcessor
extends AbstractDatatablesAttrProcessor {
    private static Logger logger = LoggerFactory.getLogger(TableThemeOptionAttrProcessor.class);

    public TableThemeOptionAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 8000;
    }

    @Override
    protected ProcessorResult doProcessAttribute(Arguments arguments, Element element, String attributeName, HtmlTable table) {
        String attrValue = element.getAttributeValue(attributeName);
        if (table != null) {
            ThemeOption themeOption = null;
            try {
                themeOption = ThemeOption.valueOf((String)attrValue.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                logger.error("{} is not a valid value among {}", (Object)attrValue, (Object)ThemeOption.values());
                throw new DataTableProcessingException((Throwable)e);
            }
            table.setThemeOption(themeOption);
        }
        return ProcessorResult.ok();
    }
}

