/*
 * Copyright 2017 Daniel Nilsson
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
 * file except in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.github.dannil.scbjavaclient.constants;

/**
 * <p>Constants which hold specific values for use by the various models.</p>
 *
 * @since 0.2.0
 */
public final class ModelConstants {

    /**
     * <p>The default number of characters to use for the StringBuilder in the
     * <code>toString()</code> method.</p>
     */
    public static final int TOSTRING_BUILDER_LENGTH = 128;

    /**
     * <p>Private constructor to prevent instantiation.</p>
     */
    private ModelConstants() {

    }

}
