/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.client;

import com.github.dannil.scbjavaclient.communication.CommunicationProtocol;
import com.github.dannil.scbjavaclient.communication.URLEndpoint;
import com.github.dannil.scbjavaclient.communication.http.HttpStatusCode;
import com.github.dannil.scbjavaclient.communication.http.requester.AbstractRequester;
import com.github.dannil.scbjavaclient.communication.http.requester.GETRequester;
import com.github.dannil.scbjavaclient.communication.http.requester.POSTRequester;
import com.github.dannil.scbjavaclient.constants.APIConstants;
import com.github.dannil.scbjavaclient.exception.SCBClientResponseTooLargeException;
import com.github.dannil.scbjavaclient.format.json.JsonCustomResponseFormat;
import com.github.dannil.scbjavaclient.model.ResponseModel;
import com.github.dannil.scbjavaclient.utility.Localization;
import com.github.dannil.scbjavaclient.utility.QueryBuilder;
import com.github.dannil.scbjavaclient.utility.StreamUtility;
import java.net.http.HttpResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractClient.class);
    private CommunicationProtocol communicationProtocol = CommunicationProtocol.HTTPS;
    private Locale locale = Locale.getDefault();
    private Localization localization = new Localization(this.locale);

    protected AbstractClient() {
    }

    protected AbstractClient(Locale locale) {
        this();
        this.locale = locale;
        this.localization.setLocale(this.locale);
    }

    public CommunicationProtocol getCommunicationProtocol() {
        return this.communicationProtocol;
    }

    public void setCommunicationProtocol(CommunicationProtocol communicationProtocol) {
        this.communicationProtocol = communicationProtocol;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.localization.setLocale(locale);
    }

    public Locale getLocalizationLocale() {
        return this.localization.getLocale();
    }

    public void setLocalizationLocale(Locale loc) {
        this.localization.setLocale(loc);
    }

    protected URLEndpoint getRootUrl() {
        return URLEndpoint.getRootUrl(this.locale, this.communicationProtocol);
    }

    protected String doGetRequest(String url) {
        GETRequester get = new GETRequester();
        return this.handleRequest(get, url);
    }

    protected String doPostRequest(String url, String query) {
        POSTRequester post = new POSTRequester();
        post.setQuery(query);
        return this.handleRequest(post, url);
    }

    private String handleRequest(AbstractRequester requester, String url) {
        HttpResponse<String> response = requester.getResponse(url);
        String body = null;
        URLEndpoint endpointUrl = new URLEndpoint(url);
        String urlLanguage = endpointUrl.getLanguage();
        if (response.statusCode() == HttpStatusCode.OK.getCode()) {
            body = StreamUtility.skipUnicodeByteOrderMark(response.body());
        } else {
            if (response.statusCode() == HttpStatusCode.NOT_FOUND.getCode() && !Objects.equals(urlLanguage, APIConstants.FALLBACK_LOCALE.getLanguage())) {
                URLEndpoint fallbackEndpointUrl = endpointUrl.toURL(APIConstants.FALLBACK_LOCALE);
                LOGGER.debug("Couldn't find table {} for locale {}, retrying with fallback locale {}", new Object[]{endpointUrl.getTable(), this.locale.getLanguage(), APIConstants.FALLBACK_LOCALE.getLanguage()});
                return this.handleRequest(requester, fallbackEndpointUrl.toString());
            }
            if (response.statusCode() == HttpStatusCode.FORBIDDEN.getCode()) {
                throw new SCBClientResponseTooLargeException("The response exceeded the maximum size allowed by the API");
            }
        }
        return body;
    }

    protected List<ResponseModel> getResponseModels(String table) {
        HashMap mappings = new HashMap();
        return this.getResponseModels(table, mappings);
    }

    protected List<ResponseModel> getResponseModels(String table, Map<String, Collection<?>> mappings) {
        String response = this.doPostRequest(this.getUrl() + table, QueryBuilder.build(mappings));
        JsonCustomResponseFormat format = new JsonCustomResponseFormat(response);
        return format.toListOf(ResponseModel.class);
    }

    public abstract URLEndpoint getUrl();
}

