/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.client;

import com.github.dannil.scbjavaclient.client.AbstractContainerClient;
import com.github.dannil.scbjavaclient.client.agriculture.AgricultureClient;
import com.github.dannil.scbjavaclient.client.businessactivities.BusinessActivitiesClient;
import com.github.dannil.scbjavaclient.client.educationandresearch.EducationAndResearchClient;
import com.github.dannil.scbjavaclient.client.energy.EnergyClient;
import com.github.dannil.scbjavaclient.client.environment.EnvironmentClient;
import com.github.dannil.scbjavaclient.client.financialmarkets.FinancialMarketsClient;
import com.github.dannil.scbjavaclient.client.goodsandservices.GoodsAndServicesClient;
import com.github.dannil.scbjavaclient.client.labourmarket.LabourMarketClient;
import com.github.dannil.scbjavaclient.client.livingconditions.LivingConditionsClient;
import com.github.dannil.scbjavaclient.client.population.PopulationClient;
import com.github.dannil.scbjavaclient.client.pricesandconsumption.PricesAndConsumptionClient;
import com.github.dannil.scbjavaclient.client.publicfinances.PublicFinancesClient;
import com.github.dannil.scbjavaclient.client.transport.TransportClient;
import com.github.dannil.scbjavaclient.communication.URLEndpoint;
import com.github.dannil.scbjavaclient.communication.http.HttpStatusCode;
import com.github.dannil.scbjavaclient.communication.http.requester.AbstractRequester;
import com.github.dannil.scbjavaclient.communication.http.requester.GETRequester;
import com.github.dannil.scbjavaclient.format.json.JsonAPIConfigTableFormat;
import com.github.dannil.scbjavaclient.format.json.JsonAPITableFormat;
import com.github.dannil.scbjavaclient.utility.QueryBuilder;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SCBClient
extends AbstractContainerClient {
    public SCBClient() {
        this.addClient("agriculture", new AgricultureClient());
        this.addClient("businessactivities", new BusinessActivitiesClient());
        this.addClient("educationandresearch", new EducationAndResearchClient());
        this.addClient("energy", new EnergyClient());
        this.addClient("environment", new EnvironmentClient());
        this.addClient("financialmarkets", new FinancialMarketsClient());
        this.addClient("goodsandservices", new GoodsAndServicesClient());
        this.addClient("labourmarket", new LabourMarketClient());
        this.addClient("livingconditions", new LivingConditionsClient());
        this.addClient("population", new PopulationClient());
        this.addClient("pricesandconsumption", new PricesAndConsumptionClient());
        this.addClient("publicfinances", new PublicFinancesClient());
        this.addClient("transport", new TransportClient());
    }

    public SCBClient(Locale locale) {
        this();
        this.setLocale(locale);
    }

    public AgricultureClient agriculture() {
        return (AgricultureClient)this.getClient("agriculture");
    }

    public BusinessActivitiesClient businessActivities() {
        return (BusinessActivitiesClient)this.getClient("businessactivities");
    }

    public EducationAndResearchClient educationAndResearch() {
        return (EducationAndResearchClient)this.getClient("educationandresearch");
    }

    public EnergyClient energy() {
        return (EnergyClient)this.getClient("energy");
    }

    public EnvironmentClient environment() {
        return (EnvironmentClient)this.getClient("environment");
    }

    public FinancialMarketsClient financialMarkets() {
        return (FinancialMarketsClient)this.getClient("financialmarkets");
    }

    public GoodsAndServicesClient goodsAndServices() {
        return (GoodsAndServicesClient)this.getClient("goodsandservices");
    }

    public LabourMarketClient labourMarket() {
        return (LabourMarketClient)this.getClient("labourmarket");
    }

    public LivingConditionsClient livingConditions() {
        return (LivingConditionsClient)this.getClient("livingconditions");
    }

    public PopulationClient population() {
        return (PopulationClient)this.getClient("population");
    }

    public PricesAndConsumptionClient pricesAndConsumption() {
        return (PricesAndConsumptionClient)this.getClient("pricesandconsumption");
    }

    public PublicFinancesClient publicFinances() {
        return (PublicFinancesClient)this.getClient("publicfinances");
    }

    public TransportClient transport() {
        return (TransportClient)this.getClient("transport");
    }

    public Map<String, Collection<String>> getInputs(String table) {
        String url = this.getUrl() + table;
        String json = this.doGetRequest(url);
        if (json == null) {
            return new HashMap<String, Collection<String>>();
        }
        return new JsonAPITableFormat(json).getPairs();
    }

    public List<String> getRegions(String table) {
        String url = this.getUrl() + table;
        String json = this.doGetRequest(url);
        if (json == null) {
            return new ArrayList<String>();
        }
        JsonAPITableFormat format = new JsonAPITableFormat(json);
        return format.getValues("Region");
    }

    public List<String> getTimes(String table) {
        String url = this.getUrl() + table;
        String json = this.doGetRequest(url);
        if (json == null) {
            return new ArrayList<String>();
        }
        JsonAPITableFormat format = new JsonAPITableFormat(json);
        return format.getValues("Tid");
    }

    public String getRawData(String table) {
        HashMap inputs = new HashMap();
        return this.getRawData(table, inputs);
    }

    public String getRawData(String table, Map<String, Collection<?>> query) {
        return this.doPostRequest(this.getUrl() + table, QueryBuilder.build(query));
    }

    public Map<String, String> getConfig() {
        String url = this.getUrl() + "?config";
        String json = this.doGetRequest(url);
        JsonAPIConfigTableFormat format = new JsonAPIConfigTableFormat(json);
        HashMap<String, String> config = new HashMap<String, String>();
        for (Map.Entry<String, Collection<String>> entry : format.getPairs().entrySet()) {
            Iterator<String> it = entry.getValue().iterator();
            config.put(entry.getKey(), it.next());
        }
        return config;
    }

    public static boolean isSupportedLanguage(String language) {
        Locale locale = new Locale(language);
        return SCBClient.isSupportedLocale(locale);
    }

    public static boolean isSupportedLocale(Locale locale) {
        GETRequester get = new GETRequester();
        String url = URLEndpoint.getRootUrl(locale).toString();
        HttpResponse<String> response = ((AbstractRequester)get).getResponse(url);
        return response.statusCode() == HttpStatusCode.OK.getCode();
    }

    @Override
    public URLEndpoint getUrl() {
        return this.getRootUrl();
    }
}

