/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.client.labourmarket.costindex;

import com.github.dannil.scbjavaclient.client.AbstractClient;
import com.github.dannil.scbjavaclient.communication.URLEndpoint;
import com.github.dannil.scbjavaclient.model.ResponseModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class LabourMarketCostIndexClient
extends AbstractClient {
    public LabourMarketCostIndexClient() {
    }

    public LabourMarketCostIndexClient(Locale locale) {
        super(locale);
    }

    public List<ResponseModel> getCostIndexForManualWorkersLCI() {
        return this.getCostIndexForManualWorkersLCI(null, null);
    }

    public List<ResponseModel> getCostIndexForManualWorkersLCI(Collection<String> industrialClassifications, Collection<String> quarters) {
        return this.generate(industrialClassifications, quarters, "LCIArbKv");
    }

    public List<ResponseModel> getCostIndexForNonManualWorkersLCI() {
        return this.getCostIndexForNonManualWorkersLCI(null, null);
    }

    public List<ResponseModel> getCostIndexForNonManualWorkersLCI(Collection<String> industrialClassifications, Collection<String> quarters) {
        return this.generate(industrialClassifications, quarters, "LCItjmKv");
    }

    public List<ResponseModel> getCostIndexForManualWorkersWAG() {
        return this.getCostIndexForManualWorkersLCI(null, null);
    }

    public List<ResponseModel> getCostIndexForManualWorkersWAG(Collection<String> industrialClassifications, Collection<String> quarters) {
        return this.generate(industrialClassifications, quarters, "WAGArbKv");
    }

    public List<ResponseModel> getCostIndexForNonManualWorkersWAG() {
        return this.getCostIndexForNonManualWorkersLCI(null, null);
    }

    public List<ResponseModel> getCostIndexForNonManualWorkersWAG(Collection<String> industrialClassifications, Collection<String> quarters) {
        return this.generate(industrialClassifications, quarters, "WAGtjmKv");
    }

    private List<ResponseModel> generate(Collection<String> industrialClassifications, Collection<String> quarters, String table) {
        HashMap mappings = new HashMap();
        mappings.put("SNI2007", industrialClassifications);
        mappings.put("Tid", quarters);
        return this.getResponseModels(table, mappings);
    }

    @Override
    public URLEndpoint getUrl() {
        return this.getRootUrl().append("AM/AM0114/");
    }
}

