/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.communication;

import com.github.dannil.scbjavaclient.communication.CommunicationProtocol;
import com.github.dannil.scbjavaclient.constants.APIConstants;
import java.net.URL;
import java.util.Locale;
import java.util.Objects;

public class URLEndpoint {
    private static final char TRAILING_SLASH = '/';
    private String url;

    public URLEndpoint(URL url) {
        this(url.toString());
    }

    public URLEndpoint(String url) {
        this.url = url;
        char[] chars = this.url.toCharArray();
        if (chars[chars.length - 1] != '/') {
            this.url = this.url + "/";
        }
    }

    public URLEndpoint append(String str) {
        return new URLEndpoint(this.url + str);
    }

    public String getLanguage() {
        StringBuilder builder = new StringBuilder(this.url);
        String startSegment = "doris";
        int start = builder.toString().indexOf(startSegment) + startSegment.length() + 1;
        int end = builder.toString().indexOf(47, start);
        return builder.substring(start, end);
    }

    public String getTable() {
        String startSegment = "ssd";
        return this.url.substring(this.url.indexOf(startSegment) + startSegment.length() + 1);
    }

    public URLEndpoint toURL(Locale locale) {
        return this.toURL(locale.getLanguage());
    }

    public URLEndpoint toURL(String language) {
        return this.toURL(language, null);
    }

    public URLEndpoint toURL(String language, CommunicationProtocol communicationProtocol) {
        StringBuilder builder = new StringBuilder(this.url);
        if (communicationProtocol != null) {
            String protocol = communicationProtocol.getProtocol();
            builder.replace(0, builder.toString().indexOf("://"), protocol);
        }
        String startSegment = "doris";
        int start = builder.toString().indexOf(startSegment) + startSegment.length() + 1;
        int end = builder.toString().indexOf(47, start);
        builder.replace(start, end, language);
        return new URLEndpoint(builder.toString());
    }

    public int hashCode() {
        return Objects.hashCode(this.url);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof URLEndpoint)) {
            return false;
        }
        URLEndpoint other = (URLEndpoint)obj;
        return Objects.equals(this.url, other.url);
    }

    public String toString() {
        return this.url;
    }

    public static URLEndpoint getRootUrl() {
        return new URLEndpoint(APIConstants.ROOT_URL);
    }

    public static URLEndpoint getRootUrl(Locale locale) {
        return new URLEndpoint(APIConstants.ROOT_URL).toURL(locale);
    }

    public static URLEndpoint getRootUrl(Locale locale, CommunicationProtocol communicationProtocol) {
        return new URLEndpoint(APIConstants.ROOT_URL).toURL(locale.getLanguage(), communicationProtocol);
    }
}

