/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.communication.http;

public enum HttpStatusCode {
    OK(200, "OK"),
    FORBIDDEN(403, "Forbidden"),
    NOT_FOUND(404, "Not Found"),
    TOO_MANY_REQUESTS(429, "Too Many Requests");

    private int code;
    private String description;

    private HttpStatusCode(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String asText() {
        return String.valueOf(this.code);
    }

    public static HttpStatusCode valueOf(int code) {
        for (HttpStatusCode h : HttpStatusCode.values()) {
            if (h.getCode() != code) continue;
            return h;
        }
        throw new IllegalArgumentException("No HTTP status enumerable exists for status code " + code);
    }
}

