/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.communication.http.requester;

import com.github.dannil.scbjavaclient.exception.SCBClientException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractRequester {
    private static Properties properties = new Properties();
    private Charset charset;
    private Map<String, String> requestProperties = new HashMap<String, String>();

    protected AbstractRequester() {
        this(StandardCharsets.UTF_8);
    }

    protected AbstractRequester(Charset charset) {
        this.requestProperties.put("Accept", "application/json");
        this.requestProperties.put("User-Agent", this.createUserAgent());
        this.setCharset(charset);
    }

    public abstract HttpResponse<String> getResponse(String var1);

    protected HttpResponse<String> getResponse(String url, String method) throws IOException, InterruptedException {
        return this.getResponse(url, method, "");
    }

    protected HttpResponse<String> getResponse(String url, String method, String body) throws IOException, InterruptedException {
        ArrayList<String> headers = new ArrayList<String>();
        for (Map.Entry<String, String> requestProperty : this.requestProperties.entrySet()) {
            headers.add(requestProperty.getKey());
            headers.add(requestProperty.getValue());
        }
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofString(body, this.getCharset());
        if (body.isEmpty()) {
            bodyPublisher = HttpRequest.BodyPublishers.noBody();
        }
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(url)).headers(headers.toArray(new String[0])).method(method, bodyPublisher);
        HttpRequest request = builder.build();
        return client.send(request, HttpResponse.BodyHandlers.ofString(this.getCharset()));
    }

    public final Charset getCharset() {
        return this.charset;
    }

    public final void setCharset(Charset charset) {
        this.charset = charset;
        this.requestProperties.put("Accept-Charset", this.charset.name());
        this.requestProperties.put("Content-Type", "application/json; charset=" + this.charset.name().toLowerCase(Locale.ENGLISH));
    }

    private String createUserAgent() {
        String artifactId = properties.getProperty("artifactId");
        String version = properties.getProperty("version");
        String url = properties.getProperty("url");
        StringBuilder builder = new StringBuilder();
        builder.append(artifactId);
        builder.append('/');
        builder.append(version);
        builder.append(" (");
        builder.append(url);
        builder.append("), ");
        builder.append(System.getProperty("os.name"));
        return builder.toString();
    }

    static {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try (InputStream input = loader.getResourceAsStream("project.properties");){
            properties.load(input);
        }
        catch (IOException e) {
            throw new SCBClientException(e);
        }
    }
}

