/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.communication.http.requester;

import com.github.dannil.scbjavaclient.communication.http.requester.AbstractRequester;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POSTRequester
extends AbstractRequester {
    private static final Logger LOGGER = LoggerFactory.getLogger(POSTRequester.class);
    private String query;

    public POSTRequester() {
    }

    public POSTRequester(Charset charset) {
        super(charset);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public HttpResponse<String> getResponse(String url) {
        if (this.query == null) {
            throw new IllegalStateException("Payload is null");
        }
        LOGGER.debug("POST: {}, {}", (Object)url, (Object)this.query);
        HttpResponse<String> response = null;
        try {
            response = this.getResponse(url, "POST", this.query);
            LOGGER.debug("HTTP {}: {}", (Object)response.statusCode(), (Object)url);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread was interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return response;
    }
}

