/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.communication.http.requester;

import com.github.dannil.scbjavaclient.communication.http.HttpRequestMethod;
import com.github.dannil.scbjavaclient.communication.http.requester.AbstractRequester;
import com.github.dannil.scbjavaclient.communication.http.requester.GETRequester;
import com.github.dannil.scbjavaclient.communication.http.requester.POSTRequester;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class RequesterFactory {
    private RequesterFactory() {
    }

    public static AbstractRequester getRequester(HttpRequestMethod method) {
        return RequesterFactory.getRequester(method, StandardCharsets.UTF_8);
    }

    public static AbstractRequester getRequester(HttpRequestMethod method, Charset charset) {
        switch (method) {
            case GET: {
                return new GETRequester(charset);
            }
            case POST: {
                return new POSTRequester(charset);
            }
        }
        throw new IllegalArgumentException(method + " is not a valid method");
    }
}

