/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.communication.http.requester;

import com.github.dannil.scbjavaclient.communication.http.HttpRequestMethod;
import com.github.dannil.scbjavaclient.communication.http.requester.AbstractRequester;
import com.github.dannil.scbjavaclient.communication.http.requester.GETRequester;
import com.github.dannil.scbjavaclient.communication.http.requester.POSTRequester;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.Map;

public final class RequesterSingletonFactory {
    private static Map<HttpRequestMethod, AbstractRequester> requesters = new EnumMap<HttpRequestMethod, AbstractRequester>(HttpRequestMethod.class);

    private RequesterSingletonFactory() {
    }

    public static AbstractRequester getRequester(HttpRequestMethod method) {
        return RequesterSingletonFactory.getRequester(method, StandardCharsets.UTF_8);
    }

    public static AbstractRequester getRequester(HttpRequestMethod method, Charset charset) {
        if (!requesters.containsKey((Object)method)) {
            throw new IllegalArgumentException(method + " is not a valid method");
        }
        AbstractRequester abs = requesters.get((Object)method);
        abs.setCharset(charset);
        return abs;
    }

    static {
        requesters.put(HttpRequestMethod.GET, GETHolder.INSTANCE);
        requesters.put(HttpRequestMethod.POST, POSTHolder.INSTANCE);
    }

    private static final class POSTHolder {
        protected static final AbstractRequester INSTANCE = new POSTRequester(StandardCharsets.UTF_8);

        private POSTHolder() {
        }
    }

    private static final class GETHolder {
        protected static final AbstractRequester INSTANCE = new GETRequester(StandardCharsets.UTF_8);

        private GETHolder() {
        }
    }
}

