/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.format.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.dannil.scbjavaclient.format.ITableFormat;
import com.github.dannil.scbjavaclient.format.json.JsonConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class JsonAPITableFormat
implements ITableFormat {
    private JsonNode json;
    private Map<String, Collection<String>> inputs;

    public JsonAPITableFormat(String json) {
        this.json = new JsonConverter().toNode(json);
    }

    @Override
    public Map<String, Collection<String>> getPairs() {
        if (this.inputs != null) {
            return this.inputs;
        }
        JsonNode variables = this.json.get("variables");
        if (variables == null) {
            return new HashMap<String, Collection<String>>();
        }
        this.inputs = new HashMap<String, Collection<String>>();
        for (int i = 0; i < variables.size(); ++i) {
            JsonNode entry = variables.get(i);
            ArrayList<String> values = new ArrayList<String>();
            JsonNode valuesNode = entry.get("values");
            for (int j = 0; j < valuesNode.size(); ++j) {
                values.add(valuesNode.get(j).asText());
            }
            this.inputs.put(entry.get("code").asText(), values);
        }
        return this.inputs;
    }

    public String toString() {
        return this.json.toString();
    }
}

