/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.format.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.github.dannil.scbjavaclient.exception.SCBClientParsingException;
import java.io.IOException;
import java.util.List;

public class JsonConverter {
    private ObjectMapper mapper = new ObjectMapper();

    public <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)this.mapper.convertValue(fromValue, toValueType);
    }

    public <T> List<T> toListOf(String json, Class<T> clazz) {
        try {
            CollectionType type = this.mapper.getTypeFactory().constructCollectionType(List.class, clazz);
            return (List)this.mapper.readValue(json, (JavaType)type);
        }
        catch (IOException e) {
            throw new SCBClientParsingException(e);
        }
    }

    public JsonNode toNode(String json) {
        return this.toNode(json, null);
    }

    public JsonNode toNode(String json, String field) {
        try {
            JsonNode node = this.mapper.readTree(json);
            if (field != null) {
                return node.get(field);
            }
            return node;
        }
        catch (IOException e) {
            throw new SCBClientParsingException(e);
        }
    }
}

