/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.format.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.dannil.scbjavaclient.format.json.JsonConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JsonCustomResponseFormat {
    private List<Map<String, Object>> entries;
    private JsonConverter converter = new JsonConverter();
    private JsonNode json;

    private JsonCustomResponseFormat() {
    }

    public JsonCustomResponseFormat(String json) {
        this();
        this.entries = new ArrayList<Map<String, Object>>();
        this.json = this.converter.toNode(json);
        this.json = this.converter.convertValue(this.getEntries(), JsonNode.class);
    }

    public List<Map<String, Object>> getEntries() {
        if (!this.entries.isEmpty()) {
            return this.entries;
        }
        JsonNode columns = this.json.get("columns");
        JsonNode data = this.json.get("data");
        ArrayList<String> contentCodes = new ArrayList<String>();
        ArrayList<String> contentCodesTexts = new ArrayList<String>();
        List codes = columns.findValuesAsText("code");
        List texts = columns.findValuesAsText("text");
        for (int i = 0; i < data.size(); ++i) {
            HashMap<String, Cloneable> map = new HashMap<String, Cloneable>();
            JsonNode entry = data.get(i);
            List types = columns.findValuesAsText("type");
            for (int l = 0; l < codes.size(); ++l) {
                if (!"c".equals(types.get(l))) continue;
                contentCodes.add((String)codes.get(l));
                contentCodesTexts.add((String)texts.get(l));
            }
            JsonNode keysNode = entry.get("key");
            JsonNode valuesNode = entry.get("values");
            HashMap<String, String> variables = new HashMap<String, String>();
            for (int j = 0; j < keysNode.size(); ++j) {
                variables.put((String)codes.get(j), keysNode.get(j).asText());
            }
            map.put("Variables", variables);
            ArrayList values = new ArrayList();
            for (int k = 0; k < valuesNode.size(); ++k) {
                HashMap<String, String> valuesContents = new HashMap<String, String>();
                valuesContents.put("Value", valuesNode.get(k).asText());
                valuesContents.put("Code", (String)contentCodes.get(k));
                valuesContents.put("Text", (String)contentCodesTexts.get(k));
                values.add(valuesContents);
            }
            map.put("Values", values);
            this.entries.add(map);
        }
        return this.entries;
    }

    public <T> List<T> toListOf(Class<T> clazz) {
        return this.converter.toListOf(this.json.toString(), clazz);
    }

    public String toString() {
        return this.json.toString();
    }
}

