/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dannil.scbjavaclient.model.ValueNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ResponseModel {
    @JsonProperty(value="Variables")
    private Map<String, String> variables = new LinkedHashMap<String, String>();
    @JsonProperty(value="Values")
    private Collection<ValueNode<String>> values = new ArrayList<ValueNode<String>>();

    public ResponseModel() {
    }

    public ResponseModel(Map<String, String> variables, Collection<ValueNode<String>> values) {
        this();
        this.variables = variables;
        this.values = values;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public Collection<ValueNode<String>> getValues() {
        return this.values;
    }

    public void setValues(Collection<ValueNode<String>> values) {
        this.values = values;
    }

    public String getVariable(String key) {
        return this.variables.get(key);
    }

    public void setVariable(String key, String value) {
        this.variables.put(key, value);
    }

    public ValueNode<String> getValue(String code) {
        for (ValueNode<String> v : this.values) {
            if (!Objects.equals(code, v.getCode())) continue;
            return v;
        }
        return null;
    }

    public void setValue(String code, String value) {
        ValueNode<String> v = this.getValue(code);
        if (v != null) {
            v.setValue(value);
        }
    }

    public int hashCode() {
        return Objects.hash(this.variables, this.values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseModel)) {
            return false;
        }
        ResponseModel other = (ResponseModel)obj;
        return Objects.equals(this.variables, other.variables) && Objects.equals(this.values, other.values);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("ResponseModel [variables=");
        builder.append(this.variables);
        builder.append(", values=");
        builder.append(this.values);
        builder.append(']');
        return builder.toString();
    }
}

