/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.utility;

import com.github.dannil.scbjavaclient.constants.ClientConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Localization {
    private String baseName = "languages/language";
    private Locale fallbackLocale = ClientConstants.LOCALIZATION_FALLBACK_LOCALE;
    private ResourceBundle bundle;
    private ResourceBundleEncodingControl encodingControl = new ResourceBundleEncodingControl("UTF-8");

    private Localization() {
    }

    public Localization(Locale locale) {
        this();
        this.bundle = ResourceBundle.getBundle(this.baseName, locale, this.encodingControl);
    }

    public Locale getLocale() {
        return this.bundle.getLocale();
    }

    public void setLocale(Locale locale) {
        this.bundle = ResourceBundle.getBundle(this.baseName, locale, this.encodingControl);
    }

    public String getString(String key) {
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return ResourceBundle.getBundle(this.baseName, this.fallbackLocale, this.encodingControl).getString(key);
        }
    }

    public String getString(String key, Object ... variables) {
        MessageFormat formatter = new MessageFormat("");
        formatter.setLocale(this.getLocale());
        formatter.applyPattern(this.getString(key));
        return formatter.format(variables);
    }

    private static class ResourceBundleEncodingControl
    extends ResourceBundle.Control {
        private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundleEncodingControl.class);
        private String encoding;

        protected ResourceBundleEncodingControl(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public List<String> getFormats(String baseName) {
            if (baseName == null) {
                throw new IllegalArgumentException();
            }
            return Arrays.asList("properties");
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) {
            if (baseName == null || locale == null || format == null || loader == null) {
                throw new IllegalArgumentException();
            }
            if ("properties".equals(format)) {
                String bundleName = this.toBundleName(baseName, locale);
                String resourceName = this.toResourceName(bundleName, format);
                try (InputStream stream = loader.getResourceAsStream(resourceName);){
                    PropertyResourceBundle propertyResourceBundle;
                    try (InputStreamReader streamReader = new InputStreamReader(stream, this.encoding);){
                        propertyResourceBundle = new PropertyResourceBundle(streamReader);
                    }
                    return propertyResourceBundle;
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage());
                }
            }
            return null;
        }
    }
}

