/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.utility;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class QueryBuilder {
    private static final int APPROXIMATE_OFFSET_CHARS = 44;
    private static final int APPROXIMATE_ENTRY_CHARS = 80;

    private QueryBuilder() {
    }

    private static void filterMap(Map<String, Collection<?>> inputMap, Object value) {
        Iterator<Map.Entry<String, Collection<?>>> it = inputMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Collection<?>> entry = it.next();
            if (entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty()) {
                it.remove();
                continue;
            }
            QueryBuilder.filterValue(entry.getValue(), value);
            if (!entry.getValue().isEmpty()) continue;
            it.remove();
        }
    }

    private static void filterValue(Collection<?> collection, Object value) {
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            if (!Objects.equals(value, it.next())) continue;
            it.remove();
        }
    }

    public static String build(Map<String, Collection<?>> inputMap) {
        QueryBuilder.filterMap(inputMap, null);
        int size = 44 + 80 * inputMap.size();
        StringBuilder builder = new StringBuilder(size);
        builder.append("{\"query\": [");
        Iterator<Map.Entry<String, Collection<?>>> entries = inputMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, Collection<?>> entry = entries.next();
            builder.append("{\"code\": \"");
            builder.append(entry.getKey());
            builder.append("\", \"selection\": {\"filter\": \"item\", \"values\": [");
            Iterator<?> values = entry.getValue().iterator();
            while (values.hasNext()) {
                builder.append("\"" + values.next() + "\"");
                if (!values.hasNext()) continue;
                builder.append(',');
            }
            builder.append("]}}");
            if (!entries.hasNext()) continue;
            builder.append(',');
        }
        builder.append("],\"response\": {\"format\": \"json\"}}");
        return builder.toString();
    }
}

