/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.utility;

import com.github.dannil.scbjavaclient.utility.UnicodeBOMInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StreamUtility {
    private StreamUtility() {
    }

    public static String skipUnicodeByteOrderMark(String str) {
        return StreamUtility.skipUnicodeByteOrderMark(new ByteArrayInputStream(str.getBytes()));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String skipUnicodeByteOrderMark(InputStream stream) {
        try (UnicodeBOMInputStream ubis = new UnicodeBOMInputStream(stream);){
            String string;
            ubis.skipBOM();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(ubis));){
                string = ((Stream)reader.lines().parallel()).collect(Collectors.joining());
            }
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

