/*
 * Decompiled with CFR 0.152.
 */
package com.github.dannil.scbjavaclient.utility;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class UnicodeBOMInputStream
extends InputStream {
    private final PushbackInputStream in;
    private BOM bom;
    private boolean skipped;

    public UnicodeBOMInputStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("invalid input stream: null is not allowed");
        }
        int size = 4;
        this.in = new PushbackInputStream(inputStream, size);
        byte[] bomRawBytes = new byte[4];
        int read = this.in.read(bomRawBytes);
        this.bom = this.getUtf32Bom(bomRawBytes);
        if (this.bom == null) {
            this.bom = this.getUtf8Bom(bomRawBytes);
        }
        if (this.bom == null) {
            this.bom = this.getUtf16Bom(bomRawBytes);
        }
        if (this.bom == null) {
            this.bom = BOM.NONE;
        }
        if (read > 0) {
            this.in.unread(bomRawBytes, 0, read);
        }
    }

    public final BOM getUtf32Bom(byte[] bomRawBytes) {
        if (bomRawBytes[0] == -1 && bomRawBytes[1] == -2 && bomRawBytes[2] == 0 && bomRawBytes[3] == 0) {
            return BOM.UTF_32_LE;
        }
        if (bomRawBytes[0] == 0 && bomRawBytes[1] == 0 && bomRawBytes[2] == -2 && bomRawBytes[3] == -1) {
            return BOM.UTF_32_BE;
        }
        return null;
    }

    public final BOM getUtf8Bom(byte[] bomRawBytes) {
        if (bomRawBytes[0] == -17 && bomRawBytes[1] == -69 && bomRawBytes[2] == -65) {
            return BOM.UTF_8;
        }
        return null;
    }

    public final BOM getUtf16Bom(byte[] bomRawBytes) {
        if (bomRawBytes[0] == -1 && bomRawBytes[1] == -2) {
            return BOM.UTF_16_LE;
        }
        if (bomRawBytes[0] == -2 && bomRawBytes[1] == -1) {
            return BOM.UTF_16_BE;
        }
        return null;
    }

    public final BOM getBOM() {
        return this.bom;
    }

    public final synchronized UnicodeBOMInputStream skipBOM() throws IOException {
        long skippedBytes;
        if (!this.skipped && (skippedBytes = this.in.skip(this.bom.bytes.length)) > 0L) {
            this.skipped = true;
        }
        return this;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    public static final class BOM {
        public static final BOM NONE = new BOM(new byte[0], "NONE");
        public static final BOM UTF_8 = new BOM(new byte[]{-17, -69, -65}, "UTF-8");
        public static final BOM UTF_16_LE = new BOM(new byte[]{-1, -2}, "UTF-16 little-endian");
        public static final BOM UTF_16_BE = new BOM(new byte[]{-2, -1}, "UTF-16 big-endian");
        public static final BOM UTF_32_LE = new BOM(new byte[]{-1, -2, 0, 0}, "UTF-32 little-endian");
        public static final BOM UTF_32_BE = new BOM(new byte[]{0, 0, -2, -1}, "UTF-32 big-endian");
        private final byte[] bytes;
        private final String description;

        private BOM(byte[] bom, String description) {
            assert (bom != null) : "invalid BOM: null is not allowed";
            assert (description != null) : "invalid description: null is not allowed";
            assert (description.length() != 0) : "invalid description: empty string is not allowed";
            this.bytes = bom;
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public byte[] getBytes() {
            int length = this.bytes.length;
            byte[] result = new byte[length];
            System.arraycopy(this.bytes, 0, result, 0, length);
            return result;
        }
    }
}

