/*
 * Decompiled with CFR 0.152.
 */
package com.github.dapicard.elasticsearch.curator;

import com.github.dapicard.elasticsearch.curator.configuration.Configuration;
import com.github.dapicard.elasticsearch.curator.service.CuratorService;
import com.github.dapicard.elasticsearch.curator.service.MatchingService;
import com.github.dapicard.elasticsearch.curator.transport.impl.CuratorNodeClient;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.NodeBuilder;

public class Curator {
    private static final Logger LOGGER = LogManager.getLogger(Curator.class);
    public static final String CONFIGURATION_SYS = System.getProperty("curator.configurationFile");
    public static final String ES_CONFIGURATION_SYS = System.getProperty("elasticsearch.configurationFile");
    public static final String TRANSPORT_SETTING = "transport.client.initial_nodes";
    public static final int TRANSPORT_DEFAULT_PORT = 9300;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public Curator() {
        this(Configuration.getConfiguration(), Settings.settingsBuilder().loadFromStream("elasticsearch.yml", Curator.class.getClassLoader().getResourceAsStream("elasticsearch.yml")).build());
    }

    public Curator(URL configuration, URL elasticsearchConfiguration) throws IOException {
        this(Configuration.getConfiguration(configuration), Settings.settingsBuilder().loadFromStream(elasticsearchConfiguration.getFile(), elasticsearchConfiguration.openStream()).build());
    }

    public Curator(Configuration config, Settings settings) {
        TransportClient client;
        String[] transportInitialNodes = settings.getAsArray(TRANSPORT_SETTING);
        if (transportInitialNodes != null && transportInitialNodes.length > 0) {
            client = TransportClient.builder().build();
            for (String initialNode : transportInitialNodes) {
                int port = 9300;
                LOGGER.info("Adding remote node [{}] to Transport client", new Object[]{initialNode});
                String[] splitHost = initialNode.split(":", 2);
                if (splitHost.length == 2) {
                    initialNode = splitHost[0];
                    try {
                        port = Integer.parseInt(splitHost[1]);
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.warn("The port number [{}] is not a valid port number. Using port number {}", new Object[]{splitHost[1], 9300});
                    }
                }
                client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(initialNode, port)));
            }
        } else {
            client = NodeBuilder.nodeBuilder().client(true).settings(settings).node().client();
        }
        MatchingService matchingService = new MatchingService(config);
        CuratorNodeClient transport = new CuratorNodeClient((Client)client);
        final CuratorService curatorService = new CuratorService(matchingService, transport);
        Runnable cleanup = new Runnable(){

            @Override
            public void run() {
                try {
                    curatorService.doCleanup();
                }
                catch (Exception e) {
                    LOGGER.error("Error while trying to cleanup", (Throwable)e);
                }
            }
        };
        this.scheduler.scheduleWithFixedDelay(cleanup, config.getInitialDelayDuration().getStandardSeconds(), config.getRepeatDelayDuration().getStandardSeconds(), TimeUnit.SECONDS);
    }

    public static void main(String[] args) {
        Configuration conf = null;
        if (CONFIGURATION_SYS != null && !CONFIGURATION_SYS.trim().isEmpty()) {
            try {
                URL confUrl = new URL(CONFIGURATION_SYS);
                conf = Configuration.getConfiguration(confUrl);
            }
            catch (MalformedURLException mue) {
                LOGGER.error("Unable to find the configuration file. Please provide an URL to the configuration file.", (Throwable)mue);
                System.exit(1);
            }
            catch (RuntimeException re) {
                LOGGER.error(re.getMessage(), (Throwable)re);
                System.exit(2);
            }
        } else {
            try {
                conf = Configuration.getConfiguration();
            }
            catch (RuntimeException re) {
                LOGGER.error(re.getMessage(), (Throwable)re);
                System.exit(2);
            }
        }
        Settings settings = null;
        if (ES_CONFIGURATION_SYS != null && !ES_CONFIGURATION_SYS.trim().isEmpty()) {
            try {
                URL esUrl = new URL(ES_CONFIGURATION_SYS);
                settings = Settings.settingsBuilder().loadFromStream(esUrl.getFile(), esUrl.openStream()).build();
            }
            catch (MalformedURLException mue) {
                LOGGER.error("Unable to find the ElasticSearch configuration file. Please provide an URL to this file.", (Throwable)mue);
                System.exit(1);
            }
            catch (IOException ioe) {
                LOGGER.error("An error occurs while reading the configuration URL.", (Throwable)ioe);
                System.exit(1);
            }
            catch (RuntimeException re) {
                LOGGER.error(re.getMessage(), (Throwable)re);
                System.exit(2);
            }
        } else {
            try {
                settings = Settings.settingsBuilder().loadFromStream("elasticsearch.yml", Curator.class.getClassLoader().getResourceAsStream("elasticsearch.yml")).build();
            }
            catch (RuntimeException re) {
                LOGGER.error(re.getMessage(), (Throwable)re);
                System.exit(2);
            }
        }
        new Curator(conf, settings);
    }
}

