/*
 * Decompiled with CFR 0.152.
 */
package com.github.dapicard.elasticsearch.curator.configuration;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.github.dapicard.elasticsearch.curator.configuration.CuratorIndex;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.PeriodFormat;
import org.joda.time.format.PeriodFormatter;

public class Configuration {
    private static final Logger LOGGER = LogManager.getLogger(Configuration.class);
    private static ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static Pattern extractVariable = Pattern.compile(".*%\\{(.+)\\}.*");
    private static PeriodFormatter periodFormatter = PeriodFormat.wordBased((Locale)Locale.ENGLISH);
    private static Configuration configuration;
    private List<CuratorIndex> curator = new ArrayList<CuratorIndex>();
    private String initialDelay;
    private String repeatDelay;
    private Period smallestPeriod;

    public List<CuratorIndex> getCurator() {
        return this.curator;
    }

    public void setCurator(List<CuratorIndex> curator) {
        this.curator = curator;
    }

    public String getInitialDelay() {
        return this.initialDelay;
    }

    public Duration getInitialDelayDuration() {
        return periodFormatter.parsePeriod(this.initialDelay).toStandardDuration();
    }

    public void setInitialDelay(String initialDelay) {
        this.initialDelay = initialDelay;
    }

    public String getRepeatDelay() {
        return this.repeatDelay;
    }

    public Duration getRepeatDelayDuration() {
        return periodFormatter.parsePeriod(this.repeatDelay).toStandardDuration();
    }

    public void setRepeatDelay(String repeatDelay) {
        this.repeatDelay = repeatDelay;
    }

    public Period getSmallestPeriod() {
        return this.smallestPeriod;
    }

    public static Configuration getConfiguration() {
        return Configuration.getConfiguration(mapper.getClass().getClassLoader().getResource("curator.yml"));
    }

    public static Configuration getConfiguration(URL confUrl) {
        if (configuration != null) {
            return configuration;
        }
        LOGGER.info("Reading configuration from {}", new Object[]{confUrl.toString()});
        try {
            configuration = (Configuration)mapper.readValue(confUrl.openStream(), Configuration.class);
        }
        catch (IOException ioe) {
            throw new RuntimeException("An error occurs while reading the configuration", ioe);
        }
        LOGGER.debug("Configuration read successfully by Jackson");
        ArrayList<CuratorIndex> toRemove = new ArrayList<CuratorIndex>();
        long now = new Date().getTime();
        for (CuratorIndex index : configuration.getCurator()) {
            Duration deleteDuration;
            LOGGER.info("Configuration for {} : ", new Object[]{index.getName()});
            Period closePeriod = periodFormatter.parsePeriod(index.getClose());
            Period deletePeriod = periodFormatter.parsePeriod(index.getDelete());
            index.setClosePeriod(closePeriod);
            index.setDeletePeriod(deletePeriod);
            if (Configuration.configuration.smallestPeriod == null) {
                Configuration.configuration.smallestPeriod = closePeriod;
            }
            Duration compareDuration = Configuration.configuration.smallestPeriod.toDurationFrom((ReadableInstant)new Instant(now));
            Duration closeDuration = closePeriod.toDurationFrom((ReadableInstant)new Instant(now));
            if (closeDuration.isShorterThan((ReadableDuration)compareDuration)) {
                compareDuration = closeDuration;
                Configuration.configuration.smallestPeriod = closePeriod;
            }
            if ((deleteDuration = deletePeriod.toDurationFrom((ReadableInstant)new Instant(now))).isShorterThan((ReadableDuration)compareDuration)) {
                compareDuration = deleteDuration;
                Configuration.configuration.smallestPeriod = deletePeriod;
            }
            LOGGER.info("[{}] looks for indexes named {}. Closes {}'s old indexes. Deletes {}'s old indexes.", new Object[]{index.getName(), index.getPattern(), closePeriod.toString(), deletePeriod.toString()});
            String basePattern = index.getPattern();
            Matcher m = extractVariable.matcher(basePattern);
            if (m.matches()) {
                String datePattern = m.group(1).replaceAll("\\+", "");
                index.setDatePattern(DateTimeFormat.forPattern((String)datePattern));
                StringBuilder indexPattern = new StringBuilder();
                indexPattern.append(basePattern.substring(0, m.start(1) - 2));
                indexPattern.append("(.+)");
                indexPattern.append(basePattern.substring(m.end(1) + 1));
                Pattern indexP = Pattern.compile(indexPattern.toString());
                index.setNamePattern(indexP);
                LOGGER.info("[{}] the extracted timestamp pattern is {} ; so the index name pattern would be {}", new Object[]{index.getName(), datePattern, index.getNamePattern()});
                continue;
            }
            LOGGER.error("[{}] the pattern {} does not seem to have a timestamp variable. Add the timestamp with %{date-pattern} in the pattern.", new Object[]{index.getName(), basePattern});
            LOGGER.error("[{}] this index will be ignored.", new Object[]{index.getName()});
            toRemove.add(index);
        }
        configuration.getCurator().removeAll(toRemove);
        return configuration;
    }
}

