/*
 * Decompiled with CFR 0.152.
 */
package com.github.dapicard.elasticsearch.curator.service;

import com.github.dapicard.elasticsearch.curator.service.MatchingService;
import com.github.dapicard.elasticsearch.curator.transport.CuratorClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CuratorService {
    private static final Logger LOGGER = LogManager.getLogger(CuratorService.class);
    private MatchingService matchingService;
    private CuratorClient transport;

    public CuratorService(MatchingService matchingService, CuratorClient transport) {
        this.matchingService = matchingService;
        this.transport = transport;
    }

    public void doCleanup() {
        LOGGER.info("Initializing indices cleanup operations...");
        for (String indice : this.transport.getOpenedIndices()) {
            LOGGER.debug("For indice named {}", new Object[]{indice});
            if (!this.matchingService.toClose(indice)) continue;
            LOGGER.info("Closing indice named {}", new Object[]{indice});
            this.transport.closeIndex(indice);
        }
        for (String indice : this.transport.getAllIndices()) {
            LOGGER.debug("For indice named {}", new Object[]{indice});
            if (!this.matchingService.toDelete(indice)) continue;
            LOGGER.info("Deleting indice named {}", new Object[]{indice});
            this.transport.deleteIndex(indice);
        }
    }
}

