/*
 * Decompiled with CFR 0.152.
 */
package com.github.dapicard.elasticsearch.curator.service;

import com.github.dapicard.elasticsearch.curator.configuration.Configuration;
import com.github.dapicard.elasticsearch.curator.configuration.CuratorIndex;
import java.util.Date;
import java.util.regex.Matcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class MatchingService {
    private static final Logger LOGGER = LogManager.getLogger(MatchingService.class);
    private Configuration configuration;

    public MatchingService(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean toDelete(String indexName) {
        return this.needAction(indexName, Action.DELETE);
    }

    public boolean toClose(String indexName) {
        return this.needAction(indexName, Action.CLOSE);
    }

    protected boolean needAction(String indexName, Action action) {
        DateTime now = new DateTime();
        for (CuratorIndex curator : this.configuration.getCurator()) {
            Matcher indexMatcher = curator.getNamePattern().matcher(indexName);
            if (!indexMatcher.matches()) continue;
            LOGGER.debug("[{}] matches index name                  : {}", new Object[]{curator.getName(), indexName});
            String dateString = indexMatcher.group(1);
            DateTime indexDate = null;
            try {
                indexDate = curator.getDatePattern().parseDateTime(dateString);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.debug("[{}] does not match date pattern         : {} - {}", new Object[]{curator.getName(), curator.getDatePattern().print(new Date().getTime()), dateString});
                continue;
            }
            if (indexDate.getSecondOfDay() == 0) {
                indexDate = indexDate.plus(86399999L);
            }
            LOGGER.debug("[{}] matches index name and date pattern : {}", new Object[]{curator.getName(), indexName});
            DateTime maxDate = indexDate;
            switch (action) {
                case CLOSE: {
                    maxDate = maxDate.plus((ReadablePeriod)curator.getClosePeriod());
                    break;
                }
                case DELETE: {
                    maxDate = maxDate.plus((ReadablePeriod)curator.getDeletePeriod());
                }
            }
            LOGGER.debug("[{}]         | now                       : {}", new Object[]{curator.getName(), now});
            LOGGER.debug("[{}]         | extracted date            : {}", new Object[]{curator.getName(), indexDate});
            LOGGER.debug("[{}]         | extracted + delete period : {}", new Object[]{curator.getName(), maxDate});
            if (now.isAfter((ReadableInstant)maxDate)) {
                LOGGER.info("[{}] needs action                        : {} on {}", new Object[]{curator.getName(), action.name(), indexName});
                return true;
            }
            LOGGER.info("[{}] does not need action                : {} on {}", new Object[]{curator.getName(), action.name(), indexName});
        }
        return false;
    }

    protected static enum Action {
        CLOSE,
        DELETE;

    }
}

