/*
 * Decompiled with CFR 0.152.
 */
package com.github.dapicard.elasticsearch.curator.transport.impl;

import com.github.dapicard.elasticsearch.curator.transport.CuratorClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.client.Client;

public class CuratorNodeClient
implements CuratorClient {
    private static final Logger LOGGER = LogManager.getLogger(CuratorNodeClient.class);
    private Client client;
    private ConcurrentLinkedQueue<String> indicesToClose = new ConcurrentLinkedQueue();
    private AtomicBoolean closeInProgress = new AtomicBoolean(false);
    private ConcurrentLinkedQueue<String> indicesToDelete = new ConcurrentLinkedQueue();
    private AtomicBoolean deleteInProgress = new AtomicBoolean(false);

    public CuratorNodeClient(Client client) {
        this.client = client;
    }

    @Override
    public Collection<String> getOpenedIndices() {
        return Arrays.asList(((ClusterStateResponse)this.client.admin().cluster().prepareState().execute().actionGet()).getState().getMetaData().concreteAllOpenIndices());
    }

    @Override
    public Collection<String> getAllIndices() {
        return Arrays.asList(((ClusterStateResponse)this.client.admin().cluster().prepareState().execute().actionGet()).getState().getMetaData().concreteAllIndices());
    }

    @Override
    public void closeIndex(String indiceName) {
        this.indicesToClose.add(indiceName);
        if (!this.closeInProgress.get()) {
            this.doClose();
        }
    }

    protected void doClose() {
        this.closeInProgress.set(true);
        final String indiceName = this.indicesToClose.poll();
        if (indiceName == null) {
            this.closeInProgress.set(false);
        } else {
            this.client.admin().indices().close(new CloseIndexRequest(new String[]{indiceName}), (ActionListener)new ActionListener<CloseIndexResponse>(){

                public void onResponse(CloseIndexResponse response) {
                    LOGGER.info("Indice <<{}>> successfully closed", new Object[]{indiceName});
                    CuratorNodeClient.this.doClose();
                }

                public void onFailure(Throwable e) {
                    LOGGER.error("Error while closing indice " + indiceName, e);
                    CuratorNodeClient.this.doClose();
                }
            });
        }
    }

    @Override
    public void deleteIndex(String indiceName) {
        this.indicesToDelete.add(indiceName);
        if (!this.deleteInProgress.get()) {
            this.doDelete();
        }
    }

    protected void doDelete() {
        this.deleteInProgress.set(true);
        final String indiceName = this.indicesToDelete.poll();
        if (indiceName == null) {
            this.deleteInProgress.set(false);
        } else {
            this.client.admin().indices().delete(new DeleteIndexRequest(indiceName), (ActionListener)new ActionListener<DeleteIndexResponse>(){

                public void onResponse(DeleteIndexResponse response) {
                    LOGGER.info("Indice <<{}>> successfully deleted", new Object[]{indiceName});
                    CuratorNodeClient.this.doDelete();
                }

                public void onFailure(Throwable e) {
                    LOGGER.error("Error while deleting indice " + indiceName, e);
                    CuratorNodeClient.this.doDelete();
                }
            });
        }
    }
}

