/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.datatables.repository;

import java.util.ArrayList;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.datatables.mapping.Column;
import org.springframework.data.jpa.datatables.mapping.DataTablesInput;
import org.springframework.data.jpa.datatables.mapping.Order;

public class DataTablesUtils {
    public static final String OR_SEPARATOR = "+";
    public static final String ESCAPED_OR_SEPARATOR = "\\+";
    public static final String ATTRIBUTE_SEPARATOR = ".";
    public static final String ESCAPED_ATTRIBUTE_SEPARATOR = "\\.";
    public static final char ESCAPE_CHAR = '\\';
    public static final String NULL = "NULL";
    public static final String ESCAPED_NULL = "\\NULL";

    public static Pageable getPageable(DataTablesInput input) {
        Sort sort;
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        for (Order order : input.getOrder()) {
            Column column = input.getColumns().get(order.getColumn());
            if (!column.getOrderable().booleanValue()) continue;
            String sortColumn = column.getData();
            Sort.Direction sortDirection = Sort.Direction.fromString((String)order.getDir());
            orders.add(new Sort.Order(sortDirection, sortColumn));
        }
        Sort sort2 = sort = orders.isEmpty() ? null : new Sort(orders);
        if (input.getLength() == -1) {
            input.setStart(0);
            input.setLength(Integer.MAX_VALUE);
        }
        return new DataTablesPageRequest(input.getStart(), input.getLength(), sort);
    }

    public static boolean isBoolean(String filterValue) {
        return "TRUE".equalsIgnoreCase(filterValue) || "FALSE".equalsIgnoreCase(filterValue);
    }

    public static String getLikeFilterValue(String filterValue) {
        return "%" + filterValue.toLowerCase().replaceAll("%", "\\\\%").replaceAll("_", "\\\\_") + "%";
    }

    private static class DataTablesPageRequest
    implements Pageable {
        private final int offset;
        private final int pageSize;
        private final Sort sort;

        public DataTablesPageRequest(int offset, int pageSize, Sort sort) {
            this.offset = offset;
            this.pageSize = pageSize;
            this.sort = sort;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public Sort getSort() {
            return this.sort;
        }

        public Pageable next() {
            throw new UnsupportedOperationException();
        }

        public Pageable previousOrFirst() {
            throw new UnsupportedOperationException();
        }

        public Pageable first() {
            throw new UnsupportedOperationException();
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        public int getPageNumber() {
            throw new UnsupportedOperationException();
        }
    }
}

