/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.datatables.repository;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Attribute;
import org.springframework.data.jpa.datatables.mapping.Column;
import org.springframework.data.jpa.datatables.mapping.DataTablesInput;
import org.springframework.data.jpa.datatables.repository.DataTablesUtils;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.StringUtils;

class SpecificationFactory {
    SpecificationFactory() {
    }

    public static <T> Specification<T> createSpecification(DataTablesInput input) {
        return new DataTablesSpecification(input);
    }

    private static <S> Expression<S> getExpression(Root<?> root, String columnData, Class<S> clazz) {
        if (!columnData.contains(".")) {
            return root.get(columnData).as(clazz);
        }
        String[] values = columnData.split("\\.");
        if (root.getModel().getAttribute(values[0]).getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) {
            return root.get(values[0]).get(values[1]).as(clazz);
        }
        Join from = root;
        for (int i = 0; i < values.length - 1; ++i) {
            from = from.join(values[i], JoinType.LEFT);
        }
        return from.get(values[values.length - 1]).as(clazz);
    }

    private static class DataTablesSpecification<T>
    implements Specification<T> {
        private final DataTablesInput input;

        public DataTablesSpecification(DataTablesInput input) {
            this.input = input;
        }

        public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
            boolean isCountQuery;
            String[] values;
            Predicate predicate = cb.conjunction();
            for (Column column : this.input.getColumns()) {
                Expression stringExpression;
                Expression booleanExpression;
                String filterValue = column.getSearch().getValue();
                boolean isColumnSearchable = column.getSearchable() != false && StringUtils.hasText((String)filterValue);
                if (!isColumnSearchable) continue;
                if (filterValue.contains("+")) {
                    boolean nullable = false;
                    values = new ArrayList();
                    for (String value : filterValue.split("\\+")) {
                        if ("NULL".equals(value)) {
                            nullable = true;
                            continue;
                        }
                        values.add("\\NULL".equals(value) ? "NULL" : value);
                    }
                    if (values.size() > 0 && DataTablesUtils.isBoolean((String)values.get(0))) {
                        Object[] booleanValues = new Boolean[values.size()];
                        for (int i = 0; i < values.size(); ++i) {
                            booleanValues[i] = Boolean.valueOf((String)values.get(i));
                        }
                        booleanExpression = SpecificationFactory.getExpression(root, column.getData(), Boolean.class);
                        Predicate in = booleanExpression.in(booleanValues);
                        if (nullable) {
                            predicate = cb.and((Expression)predicate, (Expression)cb.or((Expression)in, (Expression)booleanExpression.isNull()));
                            continue;
                        }
                        predicate = cb.and((Expression)predicate, (Expression)in);
                        continue;
                    }
                    stringExpression = SpecificationFactory.getExpression(root, column.getData(), String.class);
                    if (values.isEmpty()) {
                        if (!nullable) continue;
                        predicate = cb.and((Expression)predicate, (Expression)stringExpression.isNull());
                        continue;
                    }
                    Predicate in = stringExpression.in((Collection)values);
                    if (nullable) {
                        predicate = cb.and((Expression)predicate, (Expression)cb.or((Expression)in, (Expression)stringExpression.isNull()));
                        continue;
                    }
                    predicate = cb.and((Expression)predicate, (Expression)in);
                    continue;
                }
                if (DataTablesUtils.isBoolean(filterValue)) {
                    booleanExpression = SpecificationFactory.getExpression(root, column.getData(), Boolean.class);
                    predicate = cb.and((Expression)predicate, (Expression)cb.equal(booleanExpression, (Object)Boolean.valueOf(filterValue)));
                    continue;
                }
                stringExpression = SpecificationFactory.getExpression(root, column.getData(), String.class);
                if ("NULL".equals(filterValue)) {
                    predicate = cb.and((Expression)predicate, (Expression)stringExpression.isNull());
                    continue;
                }
                String likeFilterValue = DataTablesUtils.getLikeFilterValue("\\NULL".equals(filterValue) ? "NULL" : filterValue);
                predicate = cb.and((Expression)predicate, (Expression)cb.like(cb.lower(stringExpression), likeFilterValue, '\\'));
            }
            String globalFilterValue = this.input.getSearch().getValue();
            if (StringUtils.hasText((String)globalFilterValue)) {
                Predicate matchOneColumnPredicate = cb.disjunction();
                for (Column column : this.input.getColumns()) {
                    if (!column.getSearchable().booleanValue()) continue;
                    Expression expression = SpecificationFactory.getExpression(root, column.getData(), String.class);
                    matchOneColumnPredicate = cb.or((Expression)matchOneColumnPredicate, (Expression)cb.like(cb.lower(expression), DataTablesUtils.getLikeFilterValue(globalFilterValue), '\\'));
                }
                predicate = cb.and((Expression)predicate, (Expression)matchOneColumnPredicate);
            }
            boolean bl = isCountQuery = query.getResultType() == Long.class;
            if (isCountQuery) {
                return predicate;
            }
            for (Column column : this.input.getColumns()) {
                boolean isJoinable;
                boolean bl2 = isJoinable = column.getSearchable() != false && column.getData().contains(".");
                if (!isJoinable) continue;
                values = column.getData().split("\\.");
                Attribute.PersistentAttributeType type = root.getModel().getAttribute(values[0]).getPersistentAttributeType();
                if (type != Attribute.PersistentAttributeType.ONE_TO_ONE && type != Attribute.PersistentAttributeType.MANY_TO_ONE) continue;
                Fetch fetch = null;
                for (int i = 0; i < values.length - 1; ++i) {
                    fetch = (fetch == null ? root : fetch).fetch(values[i], JoinType.LEFT);
                }
            }
            return predicate;
        }
    }
}

