package com.datastax.data.prepare.spark.dataset;

import com.datastax.insight.spec.Operator;
import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.data.prepare.spark.dataset.hierarchicalCluster.Pink;
import org.apache.spark.sql.Dataset;

/**
 *  @author yusf
 */
public class HierarchicalCluster implements Operator {

    @InsightComponent(name = "cluster", description = "cluster")
    public static <T> Dataset<T> cluster(
            @InsightComponentArg(externalInput = true, name = "数据集", description = "数据集") Dataset<T> data,
            @InsightComponentArg(externalInput = true, name = "numSplits", description = "numSplits") int numSplits,
            @InsightComponentArg(name = "K", description = "k") int K,
            @InsightComponentArg(name = "threshold", description = "threshold") double threshold,
            @InsightComponentArg(name = "tmpFileDir", description = "tmpFileDir") String tmpFileDir){
        return Pink.runCLuster(data,numSplits,K,threshold,tmpFileDir);
    }
}
