package com.datastax.data.prepare.spark.dataset;

import com.datastax.insight.spec.Operator;
import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import org.apache.spark.sql.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOperator implements Operator {
    private static Logger logger = LoggerFactory.getLogger(TestOperator.class);

    @InsightComponent(name = "println", description = "测试")
    public static <T> Dataset<T> println(
            @InsightComponentArg(externalInput = true, name = "数据集", description = "数据集") Dataset<T> data,
            @InsightComponentArg(name = "message", description = "message") String msg) {
        System.out.println(msg);
        return data;
    }

    @InsightComponent(name = "write_dataset", description = "主要用于写文件")
    public static <T> Dataset<T> writeMidData(
            @InsightComponentArg(externalInput = true, name = "数据集", description = "数据集") Dataset<T> data,
            @InsightComponentArg(name = "模式", description = "写入文件模式", defaultValue = "Overwrite", items = "Overwrite;Append;ErrorIfExists;Ignore") String mode,
            @InsightComponentArg(name = "格式", description = "格式", defaultValue = "csv", items = "csv;text;parquet;orc;json") String format,
            @InsightComponentArg(name = "是否包含文件头", description = "是否包含文件头") boolean isHeader,
            @InsightComponentArg(name = "路径", description = "路径") String path) {
        data.write().mode(mode).option("header", isHeader).format(format).save(path);
        return data;
    }

    @InsightComponent(name = "group_write_data", description = "通过group列写多个文件")
    public static <T> void writeDataByGroupCol(
            @InsightComponentArg(externalInput = true, name = "数据集", description = "数据集") Dataset<T> data,
            @InsightComponentArg(name = "列名", description = "列名") String columns,
            @InsightComponentArg(name = "模式", description = "写入文件模式", defaultValue = "Overwrite", items = "Overwrite;Append;ErrorIfExists;Ignore") String mode,
            @InsightComponentArg(name = "格式", description = "格式", defaultValue = "csv", items = "csv;text;parquet;orc;json") String format,
            @InsightComponentArg(name = "是否包含文件头", description = "是否包含文件头") boolean isHeader,
            @InsightComponentArg(name = "路径前缀", description = "路径前缀") String path,
            @InsightComponentArg(name = "type", description = "type") int type) {
//        if(type == 0) {
            data.repartition(8).write().partitionBy(columns.split(";")).mode(mode).option("header", isHeader).format(format).save(path);
//        } else if(type == 1) {
//            String[] ts = columns.split(";");
//            if(ts.length == 1) {
//                List<Row> rows = data.select(ts[0]).dropDuplicates().collectAsList();
//                for(Row r : rows) {
//                    String name = null;
//                    Column condition = null;
//                    for(int i = 0; i < r.size(); i++) {
//                        name = name == null ? r.getString(i) : name + r.getString(i);
//                        condition = data.col(ts[0]).equalTo(r.getString(i));
//                    }
//                    if(condition != null) {
//                        data.filter(condition).write().mode(mode).format(format).save(path + "/" + (name == null ? UUID.randomUUID().toString() : name));
//                    }
//
//                }
//            } else {
//                String[] copy = new String[ts.length - 1];
//                System.arraycopy(ts, 1, copy, 0, copy.length);
//                List<Row> rows = data.select(ts[0], copy).dropDuplicates().collectAsList();
//                for(Row r : rows) {
//                    String name = null;
//                    Column condition = null;
//                    for(int i = 0; i < r.size(); i++) {
//                        name = name == null ? r.getString(i) : name + r.getString(i);
//                        condition = condition == null ? data.col(ts[0]).equalTo(r.getString(i)) : condition.and(data.col(copy[i - 1]).equalTo(r.getString(i)));
//                    }
//                    if(condition != null) {
//                        data.filter(condition).write().mode(mode).format(format).save(path + "/" + (name == null ? UUID.randomUUID().toString() : name));
//                    }
//
//                }
//            }
//        } else {
//            throw new IllegalArgumentException("type应该为0或1");
//        }

    }



}
