//package com.datastax.data.prepare.spark.dataset;
//
//import com.datastax.insight.core.driver.SparkContextBuilder;
//import com.datastax.data.prepare.util.SharedMethods;
//import com.google.common.base.Strings;
//import org.apache.spark.sql.SparkSession;
//import org.apache.spark.sql.UDFRegistration;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//
//import javax.tools.JavaCompiler;
//import javax.tools.ToolProvider;
//import java.io.*;
//import java.lang.reflect.InvocationTargetException;
//import java.lang.reflect.Method;
//import java.net.MalformedURLException;
//import java.net.URL;
//import java.net.URLClassLoader;
//import java.util.ArrayList;
//import java.util.Enumeration;
//import java.util.List;
//import java.util.UUID;
//import java.util.jar.*;
//
//public class UDFOperator {
//    private static Logger logger = LoggerFactory.getLogger(UDFOperator.class);
//    private static URLClassLoader classLoader = (URLClassLoader) ClassLoader.getSystemClassLoader();
//    private static SparkSession session = SparkContextBuilder.getSession();
//    private static JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
//    private static String interfaceNameCopy ;
//    private static String typeCopy;
//
//    //    是否返回，没有返回不能构建流程
//    protected static void udf(String filePath, String type, String interfaceName, String className, String javaText) {
//        if(Strings.isNullOrEmpty(type)) {
//            logger.info("类型type为空");
//            return;
//        }
//        String suffix = "." + type;
//        List<File> files = new ArrayList<>();
//        SharedMethods.filesFilter(new File(filePath), files, suffix);
//        interfaceNameCopy = interfaceName;
//        typeCopy = type;
//        if("jar".equals(type)) {
//            if(Strings.isNullOrEmpty(filePath) || Strings.isNullOrEmpty(interfaceNameCopy)) {
//                logger.info("jar的路径或者接口名为空");
//                return ;
//            }
//            for(File file : files) {
//                loadJar(file.getAbsolutePath());
//            }
//        }
//        if("java".equals(type)) {
//            if(Strings.isNullOrEmpty(className) || Strings.isNullOrEmpty(javaText)) {
//                logger.info("类名或者java文件的文本为空");
//                return ;
//            }
////            todo 需要把路径换到服务器上，在和前端调试的时候处理
//            filePath = "/home/keqc/unsolve/jar/";
//            String classPath = filePath + "classes/";
//            text2File(filePath, className, javaText);
//            files.clear();
//            SharedMethods.filesFilter(new File(classPath), files, className + ".class");
//            for(File file : files) {
//                register("file:" + classPath, file.getAbsolutePath().substring(classPath.length(), file.getAbsolutePath().length()-6).replaceAll("/", "."));
//            }
//            delete(new File(classPath));
//        }
//        files.clear();
//        interfaceNameCopy = null;
//        typeCopy = null;
//    }
//
//    private static void loadJar(String jarPath) {
//        JarFile jarFile;
//        Enumeration<JarEntry> jarEntryEnumeration;
//        try {
//            jarFile = new JarFile(jarPath);
//            jarEntryEnumeration = jarFile.entries();
//            while (jarEntryEnumeration.hasMoreElements()) {
//                JarEntry jarEntry = jarEntryEnumeration.nextElement();
//                if(jarEntry.getName().endsWith(".class")) {
//                    String temp = jarEntry.getName().replaceAll("/", ".");
//                    register("file:" + jarPath, temp.substring(0, temp.length()-6));
//                }
//            }
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//    }
//
//    private static void register(String path, String className) {
//        initAddUrl(path);
//        Class<?> clazz;
//        Class<?> interfaze;
//        try {
//            clazz = classLoader.loadClass(className);
//            if("java".equals(typeCopy)) {
//                Method register = clazz.getDeclaredMethod("register", UDFRegistration.class);
//                Object obj = clazz.newInstance();
//                register.invoke(obj, session.udf());
//            } else {
//                interfaze = classLoader.loadClass(interfaceNameCopy);
//                if(interfaze.isAssignableFrom(clazz)) {
//                    if(!interfaze.equals(clazz)) {
//                        Method register = clazz.getDeclaredMethod("register", UDFRegistration.class);
//                        Object obj = clazz.newInstance();
//                        register.invoke(obj, session.udf());
//                    }
//                }
//            }
//
//        } catch (ClassNotFoundException e) {
//            e.printStackTrace();
//        } catch (NoSuchMethodException e) {
//            logger.error("没有参数为 UDFRegistration.class 的 register 方法");
//            e.printStackTrace();
//        } catch (IllegalAccessException e) {
//            e.printStackTrace();
//        } catch (InstantiationException e) {
//            logger.error("class 创建实例(newInstance)失败");
//            e.printStackTrace();
//        } catch (InvocationTargetException e) {
//            logger.error("方法invoke失败");
//            e.printStackTrace();
//        }
//    }
//
//    private static void initAddUrl(String path) {
//        Method addURL;
//        URL url;
//        try {
//            addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
//            addURL.setAccessible(true);
//            url = new URL(path);
//            addURL.invoke(classLoader, url);
//        } catch (NoSuchMethodException e) {
//            e.printStackTrace();
//        } catch (MalformedURLException e) {
//            e.printStackTrace();
//        } catch (IllegalAccessException e) {
//            e.printStackTrace();
//        } catch (InvocationTargetException e) {
//            e.printStackTrace();
//        }
//    }
//
//    private static void compiler(String... javaFiles) {
//        if(javaFiles.length == 0) {
//            return;
//        }
//        int result ;
//        File file = new File(javaFiles[1]);
//        if(!file.exists()) {
//            file.mkdirs();
//        }
//        result = compiler.run(null, null, null, javaFiles);  // javac -d 路径 java文件(可以多个)
//        if(result != 0) {
//            logger.info("编译错误");
//        }
//    }
//
//    //将class打包成jar， 暂时用不到
//    private static void classes2Jar(String path) {
//        File file = new File(path);
//        File[] files = file.listFiles(new FilenameFilter() {
//            @Override
//            public boolean accept(File dir, String name) {
//                return dir.isDirectory() || name.endsWith(".class");
//            }
//        });
//        Manifest manifest = new Manifest();
//        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
//        JarOutputStream out = null;
//        BufferedInputStream in = null;
//        String jarName = null;
//        try {
//            for(File temp : files) {
//                jarName = UUID.randomUUID() + ".jar";
//                out = new JarOutputStream(new FileOutputStream(jarName), manifest);
//                List<File> list = new ArrayList<>();
//                SharedMethods.filesFilter(temp, list);
//                for(File f : list) {
//                    JarEntry jarEntry = new JarEntry(f.getAbsolutePath().substring(path.length()));
//                    jarEntry.setTime(f.lastModified());
//                    out.putNextEntry(jarEntry);
//                    out.setMethod(JarOutputStream.DEFLATED);
//                    in = new BufferedInputStream(new FileInputStream(f.getAbsolutePath()));
//                    byte[] bytes = new byte[1024];
//                    int count;
//                    while(true) {
//                        count = in.read(bytes);
//                        if(count == -1) {
//                            break;
//                        }
//                        out.write(bytes, 0, count);
//                    }
//                    out.closeEntry();
//                }
//                list.clear();
//            }
//        } catch (IOException e) {
//            e.printStackTrace();
//        } finally {
//            try {
//                if(out != null) {
//                    out.close();
//                }
//                if(in != null) {
//                    in.close();
//                }
//            } catch (IOException e) {
//                e.printStackTrace();
//            }
//        }
//        loadJar(jarName);
//    }
//
//    private static void text2File(String filePath, String className, String javaText) {
//        File file = new File(filePath + className + ".java");
//        BufferedWriter writer = null;
//        try {
//            writer = new BufferedWriter(new FileWriter(file));
//            writer.write(javaText);
//        } catch (IOException e) {
//            e.printStackTrace();
//        } finally {
//            if(writer != null) {
//                try {
//                    writer.close();
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//            }
//        }
//        compiler("-d", filePath + "/classes/", file.getAbsolutePath());
//    }
//
//    private static void delete(File file) {
//        if(file.isDirectory()) {
//            File[] files = file.listFiles();
//            for(File f : files) {
//                if(f.isDirectory()) {
//                    delete(f);
//                }else {
//                    f.delete();
//                }
//            }
//        }else {
//            file.delete();
//        }
//
//
//    }
//
//}
