package com.datastax.data.prepare.spark.dataset.accumulators

import org.apache.spark.util.AccumulatorV2

class StockArrayAccumulator(s1: Int, s2: Int) extends AccumulatorV2[(Long, Long, Double), (Double, Double)]{
  var maxRows: Array[Double] = new Array[Double](s1)
  var maxColumns: Array[Double] = new Array[Double](s2)
  var flag = 0

  override def isZero: Boolean = flag == 0

  override def copy(): AccumulatorV2[(Long, Long, Double), (Double, Double)] = {
    val accu = new StockArrayAccumulator(s1, s2)
    accu.maxRows = this.maxRows
    accu.maxColumns = this.maxRows
    accu.flag = this.flag
    accu
  }

  override def reset(): Unit = {
    maxRows = new Array[Double](s1)
    maxColumns = new Array[Double](s2)
    flag = 0
  }

  override def add(v: (Long, Long, Double)): Unit = {
     flag = 1
    if(maxRows(v._1.toInt) < v._3) {
      maxRows(v._1.toInt) = v._3
    }
    if(maxColumns(v._2.toInt) < v._3) {
      maxColumns(v._2.toInt) = v._3
    }
  }

  override def merge(other: AccumulatorV2[(Long, Long, Double), (Double, Double)]): Unit = {
    val accu = other.asInstanceOf[StockArrayAccumulator]
    val t1 = accu.maxRows
    flag = 1
    t1.indices.foreach(i => {
      if(t1(i) > maxRows(i)) {
        maxRows(i) = t1(i)
      }
    })
    val t2 = accu.maxColumns
    t2.indices.foreach(i => {
      if(t2(i) > maxColumns(i)) {
        maxColumns(i) = t2(i)
      }
    })
  }

  override def value: (Double, Double) = {
    (maxRows.sum, maxColumns.sum)
  }
}
