package com.datastax.data.prepare.spark.dataset.database;

import com.datastax.insight.annonation.InsightComponent;
import com.datastax.insight.annonation.InsightComponentArg;
import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

public class HiveHandler implements DataSetOperator {
    private static final Logger logger = LoggerFactory.getLogger(HiveHandler.class);
    @InsightComponent( name = "hive->dataset", description = "hive->dataset")
    public static Dataset<Row> hsql(
            @InsightComponentArg(name = "hqls", description = "hqls",request = true) String... hqls){
        SparkSession spark = SparkSession
                .builder()
                .appName("DataExa-Insight Hive Operator")
                .getOrCreate();
        Dataset<Row> result = null;

        for(String sql : hqls){
            result = spark.sql(sql);
        }

        return result;
    }


    public static Dataset<Row> hsql(String hql){
        if (!Strings.isNullOrEmpty(hql)) {
            String[] sql = hql.split(";");
            return hsql(sql);
        }
        return null;
    }

    @InsightComponent( name = "hive->dataset", description = "hive->dataset")
    public static Dataset<Row> hsqlSimple(@InsightComponentArg(name = "hqls", description = "hqls",request = true) String hql){
        SparkSession spark = SparkSession
                .builder()
                .appName("DataExa-Insight Hive Operator")
                .getOrCreate();
        if (!Strings.isNullOrEmpty(hql)) {
            return spark.sql(hql);
        }
        return null;
    }

    @InsightComponent( name = "hive->table", description = "hive->table")
    public static void hive2table(@InsightComponentArg(name = "hsqlAndTable", description = "hsqlAndTable",request = true) List<Map<String,String>> hsqlMap) {
        SparkSession spark = SparkSession
                .builder()
                .appName("DataExa-Insight Hive Operator")
                .getOrCreate();

        for (Map map : hsqlMap) {
            Dataset<Row> result = spark.sql(map.get("hsql").toString());
            result.createOrReplaceTempView(map.get("table").toString());
        }
    }

    @InsightComponent( name = "hive->table", description = "hive->table")
    public static <T> String hive2table(
            @InsightComponentArg(externalInput = true,name = "数据集", description = "数据集",request = true,defaultValue = "${output}") Dataset<T> dataset,
            @InsightComponentArg(name = "表名", description = "表名",request = true) String table,
            @InsightComponentArg(name = "hsqlAndTable", description = "hsqlAndTable",request = true) String sqls) {
        SparkSession spark = SparkSession
                .builder()
                .appName("DataExa-Insight Hive Operator")
                .getOrCreate();
        if (!Strings.isNullOrEmpty(sqls)) {
            String[] hsqlTuple = sqls.split(";");
            for (String tuple : hsqlTuple) {
                if (!Strings.isNullOrEmpty(tuple)) {
                    String[] sqlAndTable = tuple.split("--");
                    Dataset<Row> result = spark.sql(sqlAndTable[0].trim());
                    result.createOrReplaceTempView(sqlAndTable[1].trim());
                }
            }
        }
        dataset.createOrReplaceTempView(table);
        return "true";
    }

    @InsightComponent( name = "hive->table", description = "hive->table")
    public static <T> void hive2table(
            @InsightComponentArg(name = "hsqlAndTable", description = "hsqlAndTable",request = true) String sqls) {
        SparkSession spark = SparkSession
                .builder()
                .appName("DataExa-Insight Hive Operator")
                .getOrCreate();
        if (!Strings.isNullOrEmpty(sqls)) {
            String[] hsqlTuple = sqls.split(";");
            for (String tuple : hsqlTuple) {
                if (!Strings.isNullOrEmpty(tuple)) {
                    String[] sqlAndTable = tuple.split("--");
                    Dataset<Row> result = spark.sql(sqlAndTable[0].trim());
                    result.createOrReplaceTempView(sqlAndTable[1].trim());
                }
            }
        }
    }

    @InsightComponent( name = "dataset->table", description = "dataset->table")
    public static String dataset2table(@InsightComponentArg(name = "数据集", description = "数据集",request = true,defaultValue = "${output}") Dataset<Row> dataset,
                                     @InsightComponentArg(name = "临时表", description = "临时表",request = true) String table) {
        if (!(dataset == null) && !Strings.isNullOrEmpty(table)) {
            dataset.createOrReplaceTempView(table);
        }
        return "true";
    }

    @InsightComponent( name = "dataset->table", description = "dataset->table")
    public static org.apache.spark.ml.feature.StringIndexer dataset2table2(@InsightComponentArg(name = "数据集", description = "数据集",request = true,defaultValue = "${output}") Dataset<Row> dataset,
                                       @InsightComponentArg(name = "临时表", description = "临时表",request = true) String table) {
        if (!(dataset == null) && !Strings.isNullOrEmpty(table)) {
            dataset.createOrReplaceTempView(table);
        }
        return null;
    }
}
