package com.datastax.data.prepare.spark.dataset.hierarchicalCluster.algorithm;

import com.datastax.data.prepare.spark.dataset.hierarchicalCluster.entry.Edge;
import com.google.common.collect.Lists;
import scala.Tuple2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * date:18-7-3
 *
 * @author :xujiaji (xujj@dataexa.com)).
 *         motto :change the world by program
 */
public class PinkMSTEdge {

    private int partitionId;

    private List<Edge> edgeList = new ArrayList<>();

    public PinkMSTEdge(List<Edge> edgeList,int partitionId){
        this.edgeList = edgeList;
        this.partitionId = partitionId;
    }

    public List<Tuple2<Integer, Edge>> mining(){
        List<Tuple2<Integer, Edge>> edgePairs = Lists.newArrayListWithCapacity(edgeList.size());
        for (Edge edge : edgeList) {
            edgePairs.add(new Tuple2<Integer,Edge> (this.partitionId, edge));
        }
        Collections.sort(edgePairs, new PinkMSTEdge.MyEdgeComparable());
        return edgePairs;
    }

    private class MyEdgeComparable implements Comparator<Tuple2<Integer, Edge>> {
        @Override
        public int compare(Tuple2<Integer, Edge> o1, Tuple2<Integer, Edge> o2) {
            Edge e1 = o1._2;
            Edge e2 = o2._2;
            return (e1.getWeight() < e2.getWeight()) ? -1 : (e1.getWeight() == e2.getWeight()) ? 0 : 1;
        }
    }

}
