package com.datastax.data.prepare.spark.dataset.hierarchicalCluster.entry;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;

import java.io.Serializable;

/**
 * Created by cjin on 4/10/14.
 */

public class Edge implements Cloneable, Serializable, KryoSerializable {
    protected int left;
    protected int right;
    protected double weight;


    public Edge(){

    }

   public Edge(int end1, int end2, double weight) {
        this.left = end1;
        this.right = end2;
        this.weight = weight;
    }

  public  int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public  double getWeight() {
        return this.weight;
    }


    @Override
    public Edge clone() throws CloneNotSupportedException {
        return (Edge) super.clone();
    }

//    @Override
//    public String toString() {
//        return String.format("[(%d %d) %f]", left, right, weight);
//    }

    @Override
    public void write(Kryo kryo, Output output) {
        output.writeInt(left, true);
        output.writeInt(right,true);
        output.writeDouble(weight);
    }

    @Override
    public void read(Kryo kryo, Input input) {
        this.left = input.readInt(true);
        this.right = input.readInt(true);
        this.weight = input.readDouble();
    }
}
