package com.datastax.data.prepare.spark.dataset.hierarchicalCluster.writable;

import com.datastax.data.prepare.spark.dataset.hierarchicalCluster.entry.Edge;
import org.apache.hadoop.io.Writable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

/**
 * date:18-7-3
 *
 * @author :xujiaji (xujj@dataexa.com)).
 *         motto :change the world by program
 */
public final class EdgeWritable extends Edge implements Writable {

    private static final long serialVersionUID = 1L;


    public EdgeWritable(){
        super();
    }
    public EdgeWritable(EdgeWritable edgeWritable){
        super();
    }

    public EdgeWritable(Edge edge) {
        super(edge.getLeft(),edge.getRight(),edge.getWeight());
    }

    @Override
    public EdgeWritable clone() throws CloneNotSupportedException {
        return (EdgeWritable)super.clone();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(getLeft());
        dataOutput.writeInt(getRight());
        dataOutput.writeDouble(getWeight());
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof PointWritable)) {
            throw new RuntimeException("other has wrong type");
        }
        EdgeWritable otherP = (EdgeWritable) other;
        if (left == otherP.getLeft() && right ==otherP.getRight() && weight == otherP.getWeight()) {
            return true;
        }
        return false;
    }



    @Override
    public void readFields(DataInput dataInput) throws IOException {
      left =  dataInput.readInt();
      right = dataInput.readInt();
      weight = dataInput.readDouble();
    }
}
