package com.datastax.data.prepare.spark.dataset.louvain

import com.esotericsoftware.kryo.{Kryo, KryoSerializable}
import com.esotericsoftware.kryo.io.{Input, Output}

class LouvainData2(var community: Long,
                  var communitySigmaTot: Double,
                  var internalWeight: Double,
                  var nodeWeight: Double,
                  var changed: Boolean) extends Serializable with KryoSerializable {

  def this() = this(-1L, 0.0, 0.0, 0.0, false)

  override def toString: String =
    s"{community:$community,communitySigmaTot:$communitySigmaTot,internalWeight:$internalWeight,nodeWeight:$nodeWeight}"

  override def write(kryo: Kryo, output: Output): Unit = {
    kryo.writeObject(output, this.community)
    kryo.writeObject(output, this.communitySigmaTot)
    kryo.writeObject(output, this.internalWeight)
    kryo.writeObject(output, this.nodeWeight)
    kryo.writeObject(output, this.changed)
  }

  override def read(kryo: Kryo, input: Input): Unit = {
    this.community = kryo.readObject(input, classOf[Long])
    this.communitySigmaTot = kryo.readObject(input, classOf[Double])
    this.internalWeight = kryo.readObject(input, classOf[Double])
    this.nodeWeight = kryo.readObject(input, classOf[Double])
    this.changed = kryo.readObject(input, classOf[Boolean])
  }
}

